/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.ChangeEventDispatcher;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.SimpleChangeEventDispatcher;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.TreeChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSupport
implements Serializable {
    protected final Model source;
    private transient GenericListenerList[] genericListeners = EMPTY_GENERIC_LISTENERS;
    private static final GenericListenerList[] EMPTY_GENERIC_LISTENERS = new GenericListenerList[0];
    private AspectChild[] aspectChildren = EMPTY_ASPECT_CHILDREN;
    private static final AspectChild[] EMPTY_ASPECT_CHILDREN = new AspectChild[0];
    private static final long serialVersionUID = 1L;
    protected static final Class<StateChangeListener> STATE_CHANGE_LISTENER_CLASS = StateChangeListener.class;
    protected static final Class<PropertyChangeListener> PROPERTY_CHANGE_LISTENER_CLASS = PropertyChangeListener.class;
    protected static final Class<CollectionChangeListener> COLLECTION_CHANGE_LISTENER_CLASS = CollectionChangeListener.class;
    protected static final Class<ListChangeListener> LIST_CHANGE_LISTENER_CLASS = ListChangeListener.class;
    protected static final Class<TreeChangeListener> TREE_CHANGE_LISTENER_CLASS = TreeChangeListener.class;
    private static final Object[] EMPTY_TREE_PATH = new Object[0];

    public ChangeSupport(Model source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ChangeListener> void addListener(Class<T> listenerClass, T listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            GenericListenerList gll = this.genericListenerList(listenerClass);
            if (gll == null) {
                this.addGenericListenerList(listenerClass, listener);
            } else {
                gll.addListener(listener);
            }
        }
    }

    protected GenericListenerList genericListenerList(Class<? extends ChangeListener> listenerClass) {
        GenericListenerList[] genericListenerListArray = this.genericListeners;
        int n = this.genericListeners.length;
        int n2 = 0;
        while (n2 < n) {
            GenericListenerList gll = genericListenerListArray[n2];
            if (gll.listenerClass == listenerClass) {
                return gll;
            }
            ++n2;
        }
        return null;
    }

    protected <T extends ChangeListener> GenericListenerList addGenericListenerList(Class<T> listenerClass, T listener) {
        GenericListenerList gll = new GenericListenerList(listenerClass, listener);
        this.genericListeners = CollectionTools.add(this.genericListeners, gll);
        return gll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ChangeListener> void addListener(String aspectName, Class<T> listenerClass, T listener) {
        if (aspectName == null || listener == null) {
            throw new NullPointerException();
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ChangeSupport child = this.child(aspectName);
            if (child == null) {
                child = this.addChild(aspectName);
            }
            child.addListener(listenerClass, listener);
        }
    }

    protected ChangeSupport child(String aspectName) {
        if (aspectName == null) {
            return null;
        }
        AspectChild[] aspectChildArray = this.aspectChildren;
        int n = this.aspectChildren.length;
        int n2 = 0;
        while (n2 < n) {
            AspectChild aspectChild = aspectChildArray[n2];
            if (aspectChild.aspectName == aspectName) {
                return aspectChild.child;
            }
            ++n2;
        }
        return null;
    }

    protected ChangeSupport addChild(String aspectName) {
        ChangeSupport child = this.buildChildChangeSupport();
        this.aspectChildren = CollectionTools.add(this.aspectChildren, new AspectChild(aspectName, child));
        return child;
    }

    protected ChangeSupport buildChildChangeSupport() {
        return new ChangeSupport(this.source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ChangeListener> void removeListener(Class<T> listenerClass, T listener) {
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            GenericListenerList gll = this.genericListenerList(listenerClass);
            if (gll == null) {
                throw new IllegalArgumentException("listener not registered");
            }
            if (!gll.removeListener(listener)) {
                throw new IllegalArgumentException("listener not registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ChangeListener> void removeListener(String aspectName, Class<T> listenerClass, T listener) {
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ChangeSupport child = this.child(aspectName);
            if (child == null) {
                throw new IllegalArgumentException("listener not registered");
            }
            child.removeListener(listenerClass, listener);
        }
    }

    protected ChangeEventDispatcher dispatcher() {
        return SimpleChangeEventDispatcher.instance();
    }

    protected ChangeListener[] listeners(Class<? extends ChangeListener> listenerClass) {
        GenericListenerList gll = this.genericListenerList(listenerClass);
        return gll == null ? null : gll.listeners;
    }

    protected synchronized <T extends ChangeListener> boolean hasAnyListeners(Class<T> listenerClass) {
        GenericListenerList gll = this.genericListenerList(listenerClass);
        return gll != null && gll.hasListeners();
    }

    protected <T extends ChangeListener> boolean hasNoListeners(Class<T> listenerClass) {
        return !this.hasAnyListeners(listenerClass);
    }

    protected synchronized boolean hasAnyListeners(Class<? extends ChangeListener> listenerClass, String aspectName) {
        if (this.hasAnyListeners(listenerClass)) {
            return true;
        }
        ChangeSupport child = this.child(aspectName);
        return child != null && child.hasAnyListeners(listenerClass);
    }

    protected <T extends ChangeListener> boolean hasNoListeners(Class<T> listenerClass, String aspectName) {
        return !this.hasAnyListeners(listenerClass, aspectName);
    }

    protected void sourceChanged(String aspectName) {
    }

    public void addStateChangeListener(StateChangeListener listener) {
        this.addListener(STATE_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeStateChangeListener(StateChangeListener listener) {
        this.removeListener(STATE_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.hasAnyListeners(STATE_CHANGE_LISTENER_CLASS);
    }

    private StateChangeListener[] stateChangeListeners() {
        return (StateChangeListener[])this.listeners(STATE_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged(StateChangeEvent event) {
        StateChangeListener[] targets = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            StateChangeListener[] stateChangeListeners = this.stateChangeListeners();
            if (stateChangeListeners != null) {
                targets = (StateChangeListener[])stateChangeListeners.clone();
            }
        }
        if (targets != null) {
            StateChangeListener[] stateChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                StateChangeListener target = stateChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.stateChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().stateChanged(target, event);
                }
                ++n2;
            }
        }
        this.sourceChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged() {
        StateChangeListener[] targets = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            StateChangeListener[] stateChangeListeners = this.stateChangeListeners();
            if (stateChangeListeners != null) {
                targets = (StateChangeListener[])stateChangeListeners.clone();
            }
        }
        if (targets != null) {
            StateChangeEvent event = null;
            StateChangeListener[] stateChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                StateChangeListener target = stateChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.stateChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new StateChangeEvent(this.source);
                    }
                    this.dispatcher().stateChanged(target, event);
                }
                ++n2;
            }
        }
        this.sourceChanged(null);
    }

    public boolean valuesAreEqual(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public boolean valuesAreDifferent(Object value1, Object value2) {
        return !this.valuesAreEqual(value1, value2);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addListener(PROPERTY_CHANGE_LISTENER_CLASS, listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.addListener(propertyName, PROPERTY_CHANGE_LISTENER_CLASS, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removeListener(PROPERTY_CHANGE_LISTENER_CLASS, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.removeListener(propertyName, PROPERTY_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyPropertyChangeListeners(String propertyName) {
        return this.hasAnyListeners(PROPERTY_CHANGE_LISTENER_CLASS, propertyName);
    }

    public boolean hasAnyPropertyChangeListeners() {
        return this.hasAnyListeners(PROPERTY_CHANGE_LISTENER_CLASS);
    }

    private PropertyChangeListener[] propertyChangeListeners() {
        return (PropertyChangeListener[])this.listeners(PROPERTY_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(PropertyChangeEvent event) {
        if (this.valuesAreEqual(event.oldValue(), event.newValue())) {
            return;
        }
        String propertyName = event.propertyName();
        PropertyChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            PropertyChangeListener[] propertyChangeListeners = this.propertyChangeListeners();
            if (propertyChangeListeners != null) {
                targets = (PropertyChangeListener[])propertyChangeListeners.clone();
            }
            child = this.child(propertyName);
        }
        if (targets != null) {
            PropertyChangeListener[] propertyChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                PropertyChangeListener target = propertyChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.propertyChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().propertyChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.firePropertyChanged(event);
        }
        this.sourceChanged(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (this.valuesAreEqual(oldValue, newValue)) {
            return;
        }
        PropertyChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            PropertyChangeListener[] propertyChangeListeners = this.propertyChangeListeners();
            if (propertyChangeListeners != null) {
                targets = (PropertyChangeListener[])propertyChangeListeners.clone();
            }
            child = this.child(propertyName);
        }
        PropertyChangeEvent event = null;
        if (targets != null) {
            PropertyChangeListener[] propertyChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                PropertyChangeListener target = propertyChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.propertyChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                    }
                    this.dispatcher().propertyChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.firePropertyChanged(propertyName, oldValue, newValue);
            } else {
                child.firePropertyChanged(event);
            }
        }
        this.sourceChanged(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        PropertyChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            PropertyChangeListener[] propertyChangeListeners = this.propertyChangeListeners();
            if (propertyChangeListeners != null) {
                targets = (PropertyChangeListener[])propertyChangeListeners.clone();
            }
            child = this.child(propertyName);
        }
        PropertyChangeEvent event = null;
        if (targets != null) {
            PropertyChangeListener[] propertyChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                PropertyChangeListener target = propertyChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.propertyChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new PropertyChangeEvent(this.source, propertyName, new Integer(oldValue), new Integer(newValue));
                    }
                    this.dispatcher().propertyChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.firePropertyChanged(propertyName, oldValue, newValue);
            } else {
                child.firePropertyChanged(event);
            }
        }
        this.sourceChanged(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        PropertyChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            PropertyChangeListener[] propertyChangeListeners = this.propertyChangeListeners();
            if (propertyChangeListeners != null) {
                targets = (PropertyChangeListener[])propertyChangeListeners.clone();
            }
            child = this.child(propertyName);
        }
        PropertyChangeEvent event = null;
        if (targets != null) {
            PropertyChangeListener[] propertyChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                PropertyChangeListener target = propertyChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.propertyChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                    }
                    this.dispatcher().propertyChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.firePropertyChanged(propertyName, oldValue, newValue);
            } else {
                child.firePropertyChanged(event);
            }
        }
        this.sourceChanged(propertyName);
    }

    public void addCollectionChangeListener(CollectionChangeListener listener) {
        this.addListener(COLLECTION_CHANGE_LISTENER_CLASS, listener);
    }

    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.addListener(collectionName, COLLECTION_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.removeListener(COLLECTION_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.removeListener(collectionName, COLLECTION_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyCollectionChangeListeners(String collectionName) {
        return this.hasAnyListeners(COLLECTION_CHANGE_LISTENER_CLASS, collectionName);
    }

    public boolean hasAnyCollectionChangeListeners() {
        return this.hasAnyListeners(COLLECTION_CHANGE_LISTENER_CLASS);
    }

    private CollectionChangeListener[] collectionChangeListeners() {
        return (CollectionChangeListener[])this.listeners(COLLECTION_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(CollectionChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String collectionName = event.collectionName();
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().itemsAdded(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsAdded(event);
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(String collectionName, Collection<?> addedItems) {
        if (addedItems.size() == 0) {
            return;
        }
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName, addedItems);
                    }
                    this.dispatcher().itemsAdded(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsAdded(collectionName, addedItems);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemAdded(String collectionName, Object addedItem) {
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName, (Collection)Collections.singleton(addedItem));
                    }
                    this.dispatcher().itemsAdded(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemAdded(collectionName, addedItem);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(CollectionChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String collectionName = event.collectionName();
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().itemsRemoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsRemoved(event);
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(String collectionName, Collection<?> removedItems) {
        if (removedItems.size() == 0) {
            return;
        }
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName, removedItems);
                    }
                    this.dispatcher().itemsRemoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsRemoved(collectionName, removedItems);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemRemoved(String collectionName, Object removedItem) {
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName, (Collection)Collections.singleton(removedItem));
                    }
                    this.dispatcher().itemsRemoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemRemoved(collectionName, removedItem);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionCleared(CollectionChangeEvent event) {
        String collectionName = event.collectionName();
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().collectionCleared(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireCollectionCleared(event);
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionCleared(String collectionName) {
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName);
                    }
                    this.dispatcher().collectionCleared(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireCollectionCleared(collectionName);
            } else {
                child.fireCollectionCleared(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionChanged(CollectionChangeEvent event) {
        String collectionName = event.collectionName();
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().collectionChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireCollectionChanged(event);
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionChanged(String collectionName) {
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.collectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.child(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.collectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName);
                    }
                    this.dispatcher().collectionChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireCollectionChanged(collectionName);
            } else {
                child.fireCollectionChanged(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    public void addListChangeListener(ListChangeListener listener) {
        this.addListener(LIST_CHANGE_LISTENER_CLASS, listener);
    }

    public void addListChangeListener(String listName, ListChangeListener listener) {
        this.addListener(listName, LIST_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeListChangeListener(ListChangeListener listener) {
        this.removeListener(LIST_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeListChangeListener(String listName, ListChangeListener listener) {
        this.removeListener(listName, LIST_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyListChangeListeners(String listName) {
        return this.hasAnyListeners(LIST_CHANGE_LISTENER_CLASS, listName);
    }

    public boolean hasAnyListChangeListeners() {
        return this.hasAnyListeners(LIST_CHANGE_LISTENER_CLASS);
    }

    private ListChangeListener[] listChangeListeners() {
        return (ListChangeListener[])this.listeners(LIST_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(ListChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String listName = event.listName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().itemsAdded(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsAdded(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(String listName, int index, List<?> addedItems) {
        if (addedItems.size() == 0) {
            return;
        }
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, addedItems);
                    }
                    this.dispatcher().itemsAdded(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsAdded(listName, index, addedItems);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemAdded(String listName, int index, Object addedItem) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, Collections.singletonList(addedItem));
                    }
                    this.dispatcher().itemsAdded(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemAdded(listName, index, addedItem);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(ListChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String listName = event.listName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().itemsRemoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsRemoved(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(String listName, int index, List<?> removedItems) {
        if (removedItems.size() == 0) {
            return;
        }
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, removedItems);
                    }
                    this.dispatcher().itemsRemoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsRemoved(listName, index, removedItems);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemRemoved(String listName, int index, Object removedItem) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, Collections.singletonList(removedItem));
                    }
                    this.dispatcher().itemsRemoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemRemoved(listName, index, removedItem);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsReplaced(ListChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String listName = event.listName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().itemsReplaced(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsReplaced(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsReplaced(String listName, int index, List<?> newItems, List<?> replacedItems) {
        if (newItems.size() == 0) {
            return;
        }
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, newItems, replacedItems);
                    }
                    this.dispatcher().itemsReplaced(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsReplaced(listName, index, newItems, replacedItems);
            } else {
                child.fireItemsReplaced(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemReplaced(String listName, int index, Object newItem, Object replacedItem) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, Collections.singletonList(newItem), Collections.singletonList(replacedItem));
                    }
                    this.dispatcher().itemsReplaced(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemReplaced(listName, index, newItem, replacedItem);
            } else {
                child.fireItemsReplaced(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsMoved(ListChangeEvent event) {
        if (event.targetIndex() == event.sourceIndex()) {
            return;
        }
        String listName = event.listName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().itemsMoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsMoved(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsMoved(String listName, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex) {
            return;
        }
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, targetIndex, sourceIndex, length);
                    }
                    this.dispatcher().itemsMoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsMoved(listName, targetIndex, sourceIndex, length);
            } else {
                child.fireItemsMoved(event);
            }
        }
        this.sourceChanged(listName);
    }

    public void fireItemMoved(String listName, int targetIndex, int sourceIndex) {
        this.fireItemsMoved(listName, targetIndex, sourceIndex, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListCleared(ListChangeEvent event) {
        String listName = event.listName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().listCleared(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireListCleared(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListCleared(String listName) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName);
                    }
                    this.dispatcher().listCleared(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireListCleared(listName);
            } else {
                child.fireListCleared(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListChanged(ListChangeEvent event) {
        String listName = event.listName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().listChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireListChanged(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListChanged(String listName) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.listChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.child(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.listChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName);
                    }
                    this.dispatcher().listChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireListChanged(listName);
            } else {
                child.fireListChanged(event);
            }
        }
        this.sourceChanged(listName);
    }

    public void addTreeChangeListener(TreeChangeListener listener) {
        this.addListener(TREE_CHANGE_LISTENER_CLASS, listener);
    }

    public void addTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.addListener(treeName, TREE_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeTreeChangeListener(TreeChangeListener listener) {
        this.removeListener(TREE_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.removeListener(treeName, TREE_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyTreeChangeListeners(String treeName) {
        return this.hasAnyListeners(TREE_CHANGE_LISTENER_CLASS, treeName);
    }

    public boolean hasAnyTreeChangeListeners() {
        return this.hasAnyListeners(TREE_CHANGE_LISTENER_CLASS);
    }

    private TreeChangeListener[] treeChangeListeners() {
        return (TreeChangeListener[])this.listeners(TREE_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeAdded(TreeChangeEvent event) {
        String treeName = event.treeName();
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.treeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.child(treeName);
        }
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.treeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().nodeAdded(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireNodeAdded(event);
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeAdded(String treeName, Object[] path) {
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.treeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.child(treeName);
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.treeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new TreeChangeEvent(this.source, treeName, path);
                    }
                    this.dispatcher().nodeAdded(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireNodeAdded(treeName, path);
            } else {
                child.fireNodeAdded(event);
            }
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeRemoved(TreeChangeEvent event) {
        String treeName = event.treeName();
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.treeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.child(treeName);
        }
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.treeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().nodeRemoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireNodeRemoved(event);
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeRemoved(String treeName, Object[] path) {
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.treeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.child(treeName);
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.treeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new TreeChangeEvent(this.source, treeName, path);
                    }
                    this.dispatcher().nodeRemoved(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireNodeRemoved(treeName, path);
            } else {
                child.fireNodeRemoved(event);
            }
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeCleared(TreeChangeEvent event) {
        String treeName = event.treeName();
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.treeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.child(treeName);
        }
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.treeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().treeCleared(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireTreeCleared(event);
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeCleared(String treeName, Object[] path) {
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.treeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.child(treeName);
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.treeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new TreeChangeEvent(this.source, treeName, path);
                    }
                    this.dispatcher().treeCleared(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireTreeCleared(treeName, path);
            } else {
                child.fireTreeCleared(event);
            }
        }
        this.sourceChanged(treeName);
    }

    public void fireTreeCleared(String treeName) {
        this.fireTreeCleared(treeName, EMPTY_TREE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged(TreeChangeEvent event) {
        String treeName = event.treeName();
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.treeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.child(treeName);
        }
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.treeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    this.dispatcher().treeChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireTreeChanged(event);
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged(String treeName, Object[] path) {
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.treeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.child(treeName);
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.treeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new TreeChangeEvent(this.source, treeName, path);
                    }
                    this.dispatcher().treeChanged(target, event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireTreeChanged(treeName, path);
            } else {
                child.fireTreeChanged(event);
            }
        }
        this.sourceChanged(treeName);
    }

    public void fireTreeChanged(String treeName) {
        this.fireTreeChanged(treeName, EMPTY_TREE_PATH);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.source);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int len1 = this.genericListeners.length;
        int i = 0;
        while (i < len1) {
            this.writeObject(s, this.genericListeners[i]);
            ++i;
        }
        s.writeObject(null);
    }

    private void writeObject(ObjectOutputStream s, GenericListenerList gll) throws IOException {
        boolean first = true;
        int len = gll.listeners.length;
        int i = 0;
        while (i < len) {
            ChangeListener listener = gll.listeners[i];
            if (listener instanceof Serializable) {
                if (first) {
                    first = false;
                    s.writeObject(gll.listenerClass);
                }
                s.writeObject(listener);
            }
            ++i;
        }
        if (!first) {
            s.writeObject(null);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object o;
        s.defaultReadObject();
        this.genericListeners = EMPTY_GENERIC_LISTENERS;
        while ((o = s.readObject()) != null) {
            Class listenerClass = (Class)o;
            GenericListenerList gll = null;
            while ((o = s.readObject()) != null) {
                if (gll == null) {
                    gll = this.addGenericListenerListInternal(listenerClass, (ChangeListener)o);
                    continue;
                }
                gll.addListener((ChangeListener)o);
            }
        }
    }

    private <T extends ChangeListener> GenericListenerList addGenericListenerListInternal(Class<T> listenerClass, ChangeListener listener) {
        return this.addGenericListenerList(listenerClass, listener);
    }

    private static class AspectChild
    implements Serializable {
        final String aspectName;
        final ChangeSupport child;
        private static final long serialVersionUID = 1L;

        AspectChild(String aspectName, ChangeSupport child) {
            this.aspectName = aspectName;
            this.child = child;
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.aspectName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericListenerList {
        final Class<? extends ChangeListener> listenerClass;
        ChangeListener[] listeners;

        <T extends ChangeListener> GenericListenerList(Class<T> listenerClass, T listener) {
            this.listenerClass = listenerClass;
            this.listeners = (ChangeListener[])Array.newInstance(listenerClass, 1);
            this.listeners[0] = listener;
        }

        void addListener(ChangeListener listener) {
            this.listeners = CollectionTools.add(this.listeners, listener);
        }

        boolean removeListener(ChangeListener listener) {
            int len = this.listeners.length;
            if (len == 0) {
                return false;
            }
            try {
                this.listeners = CollectionTools.remove(this.listeners, listener);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
            return this.listeners.length + 1 == len;
        }

        boolean hasListeners() {
            return this.listeners.length > 0;
        }

        public String toString() {
            return StringTools.buildToStringFor(this, ClassTools.shortNameFor(this.listenerClass));
        }
    }
}

