/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model;

import java.io.Serializable;
import org.eclipse.jpt.utility.internal.model.ChangeEventDispatcher;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.TreeChangeListener;

public class UIChangeEventDispatcher
implements ChangeEventDispatcher,
Serializable {
    private final PlatformAdapter platformAdapter;
    private static final long serialVersionUID = 1L;

    public UIChangeEventDispatcher(PlatformAdapter platformAdapter) {
        if (platformAdapter == null) {
            throw new NullPointerException();
        }
        this.platformAdapter = platformAdapter;
    }

    public void stateChanged(final StateChangeListener listener, final StateChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.stateChanged(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.stateChanged(event);
                }

                public String toString() {
                    return "stateChanged";
                }
            });
        }
    }

    public void propertyChanged(final PropertyChangeListener listener, final PropertyChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.propertyChanged(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.propertyChanged(event);
                }

                public String toString() {
                    return "propertyChanged";
                }
            });
        }
    }

    public void itemsAdded(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.itemsAdded(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.itemsAdded(event);
                }

                public String toString() {
                    return "itemsAdded (Collection)";
                }
            });
        }
    }

    public void itemsRemoved(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.itemsRemoved(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.itemsRemoved(event);
                }

                public String toString() {
                    return "itemsRemoved (Collection)";
                }
            });
        }
    }

    public void collectionCleared(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.collectionCleared(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.collectionCleared(event);
                }

                public String toString() {
                    return "collectionCleared";
                }
            });
        }
    }

    public void collectionChanged(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.collectionChanged(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.collectionChanged(event);
                }

                public String toString() {
                    return "collectionChanged";
                }
            });
        }
    }

    public void itemsAdded(final ListChangeListener listener, final ListChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.itemsAdded(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.itemsAdded(event);
                }

                public String toString() {
                    return "itemsAdded (List)";
                }
            });
        }
    }

    public void itemsRemoved(final ListChangeListener listener, final ListChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.itemsRemoved(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.itemsRemoved(event);
                }

                public String toString() {
                    return "itemsRemoved (List)";
                }
            });
        }
    }

    public void itemsReplaced(final ListChangeListener listener, final ListChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.itemsReplaced(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.itemsReplaced(event);
                }

                public String toString() {
                    return "itemsReplaced (List)";
                }
            });
        }
    }

    public void itemsMoved(final ListChangeListener listener, final ListChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.itemsMoved(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.itemsMoved(event);
                }

                public String toString() {
                    return "itemsMoved (List)";
                }
            });
        }
    }

    public void listCleared(final ListChangeListener listener, final ListChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.listCleared(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.listCleared(event);
                }

                public String toString() {
                    return "listCleared";
                }
            });
        }
    }

    public void listChanged(final ListChangeListener listener, final ListChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.listChanged(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.listChanged(event);
                }

                public String toString() {
                    return "listChanged";
                }
            });
        }
    }

    public void nodeAdded(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.nodeAdded(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.nodeAdded(event);
                }

                public String toString() {
                    return "nodeAdded";
                }
            });
        }
    }

    public void nodeRemoved(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.nodeRemoved(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.nodeRemoved(event);
                }

                public String toString() {
                    return "nodeRemoved";
                }
            });
        }
    }

    public void treeCleared(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.treeCleared(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.treeCleared(event);
                }

                public String toString() {
                    return "treeCleared";
                }
            });
        }
    }

    public void treeChanged(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            listener.treeChanged(event);
        } else {
            this.executeOnUIThread(new Runnable(){

                public void run() {
                    listener.treeChanged(event);
                }

                public String toString() {
                    return "treeChanged";
                }
            });
        }
    }

    private boolean isExecutingOnUIThread() {
        return this.platformAdapter.currentThreadIsUIThread();
    }

    private void executeOnUIThread(Runnable r) {
        this.platformAdapter.executeOnUIThread(r);
    }

    public static interface PlatformAdapter {
        public boolean currentThreadIsUIThread();

        public void executeOnUIThread(Runnable var1);
    }
}

