/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.listener;

import java.lang.reflect.Method;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.model.event.ChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.MultiMethodReflectiveChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.SingleMethodReflectiveChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.TreeChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveChangeListener {
    protected final Object target;
    protected static final Class<StateChangeEvent> STATE_CHANGE_EVENT_CLASS = StateChangeEvent.class;
    protected static final Class<StateChangeEvent>[] STATE_CHANGE_EVENT_CLASS_ARRAY = new Class[]{STATE_CHANGE_EVENT_CLASS};
    protected static final StateChangeEvent[] EMPTY_STATE_CHANGE_EVENT_ARRAY = new StateChangeEvent[0];
    protected static final Class<PropertyChangeEvent> PROPERTY_CHANGE_EVENT_CLASS = PropertyChangeEvent.class;
    protected static final Class<PropertyChangeEvent>[] PROPERTY_CHANGE_EVENT_CLASS_ARRAY = new Class[]{PROPERTY_CHANGE_EVENT_CLASS};
    protected static final PropertyChangeEvent[] EMPTY_PROPERTY_CHANGE_EVENT_ARRAY = new PropertyChangeEvent[0];
    protected static final Class<CollectionChangeEvent> COLLECTION_CHANGE_EVENT_CLASS = CollectionChangeEvent.class;
    protected static final Class<CollectionChangeEvent>[] COLLECTION_CHANGE_EVENT_CLASS_ARRAY = new Class[]{COLLECTION_CHANGE_EVENT_CLASS};
    protected static final CollectionChangeEvent[] EMPTY_COLLECTION_CHANGE_EVENT_ARRAY = new CollectionChangeEvent[0];
    protected static final Class<ListChangeEvent> LIST_CHANGE_EVENT_CLASS = ListChangeEvent.class;
    protected static final Class<ListChangeEvent>[] LIST_CHANGE_EVENT_CLASS_ARRAY = new Class[]{LIST_CHANGE_EVENT_CLASS};
    protected static final ListChangeEvent[] EMPTY_LIST_CHANGE_EVENT_ARRAY = new ListChangeEvent[0];
    protected static final Class<TreeChangeEvent> TREE_CHANGE_EVENT_CLASS = TreeChangeEvent.class;
    protected static final Class<TreeChangeEvent>[] TREE_CHANGE_EVENT_CLASS_ARRAY = new Class[]{TREE_CHANGE_EVENT_CLASS};
    protected static final TreeChangeEvent[] EMPTY_TREE_CHANGE_EVENT_ARRAY = new TreeChangeEvent[0];

    private static Method findChangeListenerMethod(Object target, String methodName, Class<? extends ChangeEvent>[] eventClassArray) {
        Method method;
        try {
            method = ClassTools.method(target, methodName, eventClassArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = ClassTools.method(target, methodName);
            }
            catch (NoSuchMethodException ex2) {
                throw new RuntimeException(ex2);
            }
        }
        return method;
    }

    private static void checkChangeListenerMethod(Method method, Class<? extends ChangeEvent> eventClass) {
        Class<?>[] parmTypes = method.getParameterTypes();
        int parmTypesLength = parmTypes.length;
        if (parmTypesLength == 0) {
            return;
        }
        if (parmTypesLength == 1 && parmTypes[0].isAssignableFrom(eventClass)) {
            return;
        }
        throw new IllegalArgumentException(method.toString());
    }

    public static StateChangeListener buildStateChangeListener(Object target, Method method) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, STATE_CHANGE_EVENT_CLASS);
        return new SingleMethodReflectiveChangeListener(target, method);
    }

    public static StateChangeListener buildStateChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildStateChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, STATE_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static PropertyChangeListener buildPropertyChangeListener(Object target, Method method) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, PROPERTY_CHANGE_EVENT_CLASS);
        return new SingleMethodReflectiveChangeListener(target, method);
    }

    public static PropertyChangeListener buildPropertyChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildPropertyChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, PROPERTY_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, Method addMethod, Method removeMethod, Method clearMethod, Method changeMethod) {
        ReflectiveChangeListener.checkChangeListenerMethod(addMethod, COLLECTION_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(removeMethod, COLLECTION_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(clearMethod, COLLECTION_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(changeMethod, COLLECTION_CHANGE_EVENT_CLASS);
        return new MultiMethodReflectiveChangeListener(target, addMethod, removeMethod, clearMethod, changeMethod);
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, Method method) {
        return ReflectiveChangeListener.buildCollectionChangeListener(target, method, method, method, method);
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, String addMethodName, String removeMethodName, String clearMethodName, String changeMethodName) {
        return ReflectiveChangeListener.buildCollectionChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, addMethodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, removeMethodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, clearMethodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, changeMethodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildCollectionChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static ListChangeListener buildListChangeListener(Object target, Method addMethod, Method removeMethod, Method replaceMethod, Method moveMethod, Method clearMethod, Method changeMethod) {
        ReflectiveChangeListener.checkChangeListenerMethod(addMethod, LIST_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(removeMethod, LIST_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(replaceMethod, LIST_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(moveMethod, LIST_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(clearMethod, LIST_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(changeMethod, LIST_CHANGE_EVENT_CLASS);
        return new MultiMethodReflectiveChangeListener(target, addMethod, removeMethod, replaceMethod, moveMethod, clearMethod, changeMethod);
    }

    public static ListChangeListener buildListChangeListener(Object target, Method method) {
        return ReflectiveChangeListener.buildListChangeListener(target, method, method, method, method, method, method);
    }

    public static ListChangeListener buildListChangeListener(Object target, String addMethodName, String removeMethodName, String replaceMethodName, String moveMethodName, String clearMethodName, String changeMethodName) {
        return ReflectiveChangeListener.buildListChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, addMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, removeMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, replaceMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, moveMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, clearMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, changeMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static ListChangeListener buildListChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildListChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, LIST_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static TreeChangeListener buildTreeChangeListener(Object target, Method addMethod, Method removeMethod, Method clearMethod, Method changeMethod) {
        ReflectiveChangeListener.checkChangeListenerMethod(addMethod, TREE_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(removeMethod, TREE_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(clearMethod, TREE_CHANGE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(changeMethod, TREE_CHANGE_EVENT_CLASS);
        return new MultiMethodReflectiveChangeListener(target, addMethod, removeMethod, clearMethod, changeMethod);
    }

    public static TreeChangeListener buildTreeChangeListener(Object target, Method method) {
        return ReflectiveChangeListener.buildTreeChangeListener(target, method, method, method, method);
    }

    public static TreeChangeListener buildTreeChangeListener(Object target, String addMethodName, String removeMethodName, String clearMethodName, String changeMethodName) {
        return ReflectiveChangeListener.buildTreeChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, addMethodName, TREE_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, removeMethodName, TREE_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, clearMethodName, TREE_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, changeMethodName, TREE_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static TreeChangeListener buildTreeChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildTreeChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, TREE_CHANGE_EVENT_CLASS_ARRAY));
    }

    protected ReflectiveChangeListener(Object target) {
        this.target = target;
    }
}

