/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;
import org.eclipse.jpt.utility.internal.model.value.TreeNodeValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNodeValueModel
extends AbstractModel
implements TreeNodeValueModel {
    protected AbstractTreeNodeValueModel() {
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return super.buildChangeSupport();
    }

    @Override
    public void addStateChangeListener(StateChangeListener listener) {
        if (this.hasNoStateChangeListeners()) {
            this.engageValue();
        }
        super.addStateChangeListener(listener);
    }

    protected abstract void engageValue();

    @Override
    public void removeStateChangeListener(StateChangeListener listener) {
        super.removeStateChangeListener(listener);
        if (this.hasNoStateChangeListeners()) {
            this.disengageValue();
        }
    }

    protected abstract void disengageValue();

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TreeNodeValueModel[] path() {
        List<TreeNodeValueModel> path = CollectionTools.reverseList(this.backPath());
        return path.toArray(new TreeNodeValueModel[path.size()]);
    }

    protected Iterator<TreeNodeValueModel> backPath() {
        return new ChainIterator<TreeNodeValueModel>((TreeNodeValueModel)this){

            @Override
            protected TreeNodeValueModel nextLink(TreeNodeValueModel currentLink) {
                return currentLink.parent();
            }
        };
    }

    @Override
    public TreeNodeValueModel child(int index) {
        return (TreeNodeValueModel)this.childrenModel().get(index);
    }

    @Override
    public int childrenSize() {
        return this.childrenModel().size();
    }

    @Override
    public int indexOfChild(TreeNodeValueModel child) {
        ListValueModel children = this.childrenModel();
        int size = children.size();
        int i = 0;
        while (i < size) {
            if (children.get(i) == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.childrenModel().size() == 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractTreeNodeValueModel other = (AbstractTreeNodeValueModel)o;
        return this.value().equals(other.value());
    }

    public int hashCode() {
        return this.value().hashCode();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.value());
    }
}

