/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AspectAdapter
extends AbstractModel {
    protected Object subject;
    protected final ValueModel subjectHolder;
    protected final PropertyChangeListener subjectChangeListener;

    protected AspectAdapter(Object subject) {
        this(new ReadOnlyPropertyValueModel(subject));
    }

    protected AspectAdapter(ValueModel subjectHolder) {
        if (subjectHolder == null) {
            throw new NullPointerException();
        }
        this.subjectHolder = subjectHolder;
        this.subjectChangeListener = this.buildSubjectChangeListener();
        this.subject = null;
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new LocalChangeSupport(this, this.listenerClass(), this.listenerAspectName());
    }

    protected PropertyChangeListener buildSubjectChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                AspectAdapter.this.subjectChanged();
            }

            public String toString() {
                return "subject change listener";
            }
        };
    }

    protected synchronized void subjectChanged() {
        Object oldValue = this.value();
        boolean hasListeners = this.hasListeners();
        if (hasListeners) {
            this.disengageSubject();
        }
        this.subject = this.subjectHolder.value();
        if (hasListeners) {
            this.engageSubject();
            this.fireAspectChange(oldValue, this.value());
        }
    }

    protected abstract Object value();

    protected abstract Class<? extends ChangeListener> listenerClass();

    protected abstract String listenerAspectName();

    protected abstract boolean hasListeners();

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected abstract void fireAspectChange(Object var1, Object var2);

    protected abstract void engageNonNullSubject();

    protected void engageSubject() {
        if (this.subject != null) {
            this.engageNonNullSubject();
        }
    }

    protected abstract void disengageNonNullSubject();

    protected void disengageSubject() {
        if (this.subject != null) {
            this.disengageNonNullSubject();
        }
    }

    protected void engageSubjectHolder() {
        this.subjectHolder.addPropertyChangeListener("value", this.subjectChangeListener);
        this.subject = this.subjectHolder.value();
    }

    protected void disengageSubjectHolder() {
        this.subjectHolder.removePropertyChangeListener("value", this.subjectChangeListener);
        this.subject = null;
    }

    protected void engageModels() {
        this.engageSubjectHolder();
        this.engageSubject();
    }

    protected void disengageModels() {
        this.disengageSubject();
        this.disengageSubjectHolder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LocalChangeSupport
    extends SingleAspectChangeSupport {
        private static final long serialVersionUID = 1L;

        public LocalChangeSupport(AspectAdapter source, Class<? extends ChangeListener> listenerClass, String aspectName) {
            super(source, listenerClass, aspectName);
        }

        protected boolean listenerIsRelevant(Class<? extends ChangeListener> lClass) {
            return lClass == this.listenerClass;
        }

        protected boolean hasNoRelevantListeners(Class<? extends ChangeListener> lClass) {
            return this.listenerIsRelevant(lClass) && this.hasNoListeners(lClass);
        }

        protected boolean listenerIsRelevant(Class<? extends ChangeListener> lClass, String listenerAspectName) {
            return this.listenerIsRelevant(lClass) && listenerAspectName == AspectAdapter.this.listenerAspectName();
        }

        protected boolean hasNoRelevantListeners(Class<? extends ChangeListener> lClass, String listenerAspectName) {
            return this.listenerIsRelevant(lClass, listenerAspectName) && this.hasNoListeners(lClass, listenerAspectName);
        }

        @Override
        protected <T extends ChangeListener> void addListener(Class<T> lClass, T listener) {
            if (this.hasNoRelevantListeners(lClass)) {
                AspectAdapter.this.engageModels();
            }
            super.addListener(lClass, listener);
        }

        @Override
        protected <T extends ChangeListener> void addListener(String listenerAspectName, Class<T> lClass, T listener) {
            if (this.hasNoRelevantListeners(lClass, listenerAspectName)) {
                AspectAdapter.this.engageModels();
            }
            super.addListener(listenerAspectName, lClass, listener);
        }

        @Override
        protected <T extends ChangeListener> void removeListener(Class<T> lClass, T listener) {
            super.removeListener(lClass, listener);
            if (this.hasNoRelevantListeners(lClass)) {
                AspectAdapter.this.disengageModels();
            }
        }

        @Override
        protected <T extends ChangeListener> void removeListener(String listenerAspectName, Class<T> lClass, T listener) {
            super.removeListener(listenerAspectName, lClass, listener);
            if (this.hasNoRelevantListeners(lClass, listenerAspectName)) {
                AspectAdapter.this.disengageModels();
            }
        }
    }
}

