/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueModel;

public class BufferedPropertyValueModel
extends PropertyValueModelWrapper {
    protected Object bufferedValue;
    protected boolean accepting;
    protected final ValueModel triggerHolder;
    protected final PropertyChangeListener triggerChangeListener;
    protected static final Object UNASSIGNED = new Object();

    public BufferedPropertyValueModel(PropertyValueModel valueHolder, ValueModel triggerHolder) {
        super(valueHolder);
        if (triggerHolder == null) {
            throw new NullPointerException();
        }
        this.triggerHolder = triggerHolder;
        this.bufferedValue = UNASSIGNED;
        this.accepting = false;
        this.triggerChangeListener = this.buildTriggerChangeListener();
    }

    protected PropertyChangeListener buildTriggerChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                BufferedPropertyValueModel.this.triggerChanged(e);
            }

            public String toString() {
                return "trigger change listener";
            }
        };
    }

    public Object value() {
        return this.bufferedValue == UNASSIGNED ? this.valueHolder.value() : this.bufferedValue;
    }

    public void setValue(Object value) {
        Object old = this.value();
        this.bufferedValue = value;
        this.firePropertyChanged("value", old, this.bufferedValue);
    }

    protected void engageValueHolder() {
        super.engageValueHolder();
        this.triggerHolder.addPropertyChangeListener("value", this.triggerChangeListener);
    }

    protected void disengageValueHolder() {
        this.triggerHolder.removePropertyChangeListener("value", this.triggerChangeListener);
        super.disengageValueHolder();
    }

    protected void valueChanged(PropertyChangeEvent e) {
        if (this.accepting) {
            return;
        }
        if (this.bufferedValue == UNASSIGNED) {
            this.firePropertyChanged(e.propertyName(), e.oldValue(), e.newValue());
        } else {
            this.handleChangeConflict(e);
        }
    }

    protected void handleChangeConflict(PropertyChangeEvent e) {
    }

    protected void triggerChanged(PropertyChangeEvent e) {
        if (this.bufferedValue == UNASSIGNED) {
            return;
        }
        if (((Boolean)e.newValue()).booleanValue()) {
            this.accepting = true;
            this.valueHolder.setValue(this.bufferedValue);
            this.bufferedValue = UNASSIGNED;
            this.accepting = false;
        } else {
            Object old = this.bufferedValue;
            this.bufferedValue = UNASSIGNED;
            this.firePropertyChanged("value", old, this.valueHolder.value());
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value());
    }

    public boolean isBuffering() {
        return this.bufferedValue != UNASSIGNED;
    }

    public static class Trigger
    extends SimplePropertyValueModel {
        public Object value() {
            if (this.value == null) {
                throw new IllegalStateException("The method Trigger.value() may only be called during change notification.");
            }
            return this.value;
        }

        public void setValue(Object value) {
            super.setValue(value);
            this.value = null;
        }

        public void setValue(boolean value) {
            this.setValue((Object)value);
        }

        public boolean booleanValue() {
            return (Boolean)this.value();
        }

        public void accept() {
            this.setValue(true);
        }

        public boolean isAccepted() {
            return this.booleanValue();
        }

        public void reset() {
            this.setValue(false);
        }

        public boolean isReset() {
            return !this.booleanValue();
        }
    }
}

