/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAspectAdapter
extends AspectAdapter
implements CollectionValueModel {
    protected final String collectionName;
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionAspectAdapter(String collectionName, Model subject) {
        this(new ReadOnlyPropertyValueModel(subject), collectionName);
    }

    protected CollectionAspectAdapter(ValueModel subjectHolder) {
        this(subjectHolder, null);
    }

    protected CollectionAspectAdapter(ValueModel subjectHolder, String collectionName) {
        super(subjectHolder);
        this.collectionName = collectionName;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CollectionAspectAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CollectionAspectAdapter.this.itemsRemoved(e);
            }

            public void collectionCleared(CollectionChangeEvent e) {
                CollectionAspectAdapter.this.collectionCleared(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CollectionAspectAdapter.this.collectionChanged(e);
            }

            public String toString() {
                return "collection change listener: " + CollectionAspectAdapter.this.collectionName;
            }
        };
    }

    @Override
    public Iterator iterator() {
        if (this.subject == null) {
            return EmptyIterator.instance();
        }
        return this.getValueFromSubject();
    }

    protected Iterator getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.subject == null ? 0 : this.sizeFromSubject();
    }

    protected int sizeFromSubject() {
        return CollectionTools.size(this.iterator());
    }

    @Override
    protected Object value() {
        return this.iterator();
    }

    @Override
    protected Class<? extends ChangeListener> listenerClass() {
        return CollectionChangeListener.class;
    }

    @Override
    protected String listenerAspectName() {
        return "values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("values");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireCollectionChanged("values");
    }

    @Override
    protected void engageNonNullSubject() {
        if (this.collectionName != null) {
            ((Model)this.subject).addCollectionChangeListener(this.collectionName, this.collectionChangeListener);
        }
    }

    @Override
    protected void disengageNonNullSubject() {
        if (this.collectionName != null) {
            ((Model)this.subject).removeCollectionChangeListener(this.collectionName, this.collectionChangeListener);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.collectionName);
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        this.fireItemsAdded(e.cloneWithSource(this, "values"));
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        this.fireItemsRemoved(e.cloneWithSource(this, "values"));
    }

    protected void collectionCleared(CollectionChangeEvent e) {
        this.fireCollectionCleared("values");
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        this.fireCollectionChanged("values");
    }
}

