/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public class CollectionListValueModelAdapter
extends AbstractModel
implements ListValueModel {
    protected final CollectionValueModel collectionHolder;
    protected final CollectionChangeListener collectionChangeListener;
    protected final ArrayList list;

    public CollectionListValueModelAdapter(CollectionValueModel collectionHolder) {
        if (collectionHolder == null) {
            throw new NullPointerException();
        }
        this.collectionHolder = collectionHolder;
        this.collectionChangeListener = this.buildCollectionChangeListener();
        this.list = new ArrayList();
    }

    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, ListChangeListener.class, "list values");
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CollectionListValueModelAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CollectionListValueModelAdapter.this.itemsRemoved(e);
            }

            public void collectionCleared(CollectionChangeEvent e) {
                CollectionListValueModelAdapter.this.collectionCleared(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CollectionListValueModelAdapter.this.collectionChanged(e);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return new ReadOnlyListIterator(this.list);
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    public void addListChangeListener(ListChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listener);
    }

    public void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName == "list values" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listName, listener);
    }

    public void removeListChangeListener(ListChangeListener listener) {
        super.removeListChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName == "list values" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected int lastIdentityIndexOf(Object o) {
        return this.lastIdentityIndexOf(o, this.list.size());
    }

    protected int lastIdentityIndexOf(Object o, int end) {
        int i = end;
        while (i-- > 0) {
            if (this.list.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    protected void buildList() {
        Iterator stream = this.collectionHolder.iterator();
        if (stream.hasNext()) {
            this.list.ensureCapacity(this.collectionHolder.size());
            while (stream.hasNext()) {
                this.list.add(stream.next());
            }
            this.postBuildList();
        }
    }

    protected void postBuildList() {
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("values", this.collectionChangeListener);
        this.buildList();
    }

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("values", this.collectionChangeListener);
        this.list.clear();
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        this.addItemsToList(this.indexToAddItems(), (Iterable)CollectionTools.list(e.items()), this.list, "list values");
    }

    protected int indexToAddItems() {
        return this.list.size();
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        Iterator<?> stream = e.items();
        while (stream.hasNext()) {
            this.removeItemFromList(this.lastIdentityIndexOf(stream.next()), this.list, "list values");
        }
    }

    protected void collectionCleared(CollectionChangeEvent e) {
        this.clearList(this.list, "list values");
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        if (!this.list.isEmpty()) {
            ArrayList removedItems = (ArrayList)this.list.clone();
            this.list.clear();
            this.fireItemsRemoved("list values", 0, removedItems);
        }
        this.buildList();
        if (!this.list.isEmpty()) {
            this.fireItemsAdded("list values", 0, this.list);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.collectionHolder);
    }
}

