/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;

public abstract class CollectionPropertyValueModelAdapter
extends AbstractModel
implements PropertyValueModel {
    protected Object value;
    protected final CollectionValueModel collectionHolder;
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionPropertyValueModelAdapter(CollectionValueModel collectionHolder) {
        this.collectionHolder = collectionHolder;
        this.value = null;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, PropertyChangeListener.class, "value");
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CollectionPropertyValueModelAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CollectionPropertyValueModelAdapter.this.itemsRemoved(e);
            }

            public void collectionCleared(CollectionChangeEvent e) {
                CollectionPropertyValueModelAdapter.this.collectionCleared(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CollectionPropertyValueModelAdapter.this.collectionChanged(e);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    public Object value() {
        return this.value;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == "value" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (propertyName == "value" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("values", this.collectionChangeListener);
        this.value = this.buildValue();
    }

    protected abstract Object buildValue();

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("values", this.collectionChangeListener);
        this.value = null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.collectionHolder);
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        this.propertyChanged();
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        this.propertyChanged();
    }

    protected void collectionCleared(CollectionChangeEvent e) {
        this.propertyChanged();
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        this.propertyChanged();
    }

    protected void propertyChanged() {
        Object old = this.value;
        this.value = this.buildValue();
        this.firePropertyChanged("value", old, this.value);
    }
}

