/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;

public abstract class CollectionValueModelWrapper
extends AbstractModel
implements CollectionValueModel {
    protected final CollectionValueModel collectionHolder;
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionValueModelWrapper(CollectionValueModel collectionHolder) {
        this.collectionHolder = collectionHolder;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, CollectionChangeListener.class, "values");
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CollectionValueModelWrapper.this.itemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CollectionValueModelWrapper.this.itemsRemoved(e);
            }

            public void collectionCleared(CollectionChangeEvent e) {
                CollectionValueModelWrapper.this.collectionCleared(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CollectionValueModelWrapper.this.collectionChanged(e);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    public synchronized void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoCollectionChangeListeners("values")) {
            this.engageModel();
        }
        super.addCollectionChangeListener(listener);
    }

    public synchronized void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "values" && this.hasNoCollectionChangeListeners("values")) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    public synchronized void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoCollectionChangeListeners("values")) {
            this.disengageModel();
        }
    }

    public synchronized void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "values" && this.hasNoCollectionChangeListeners("values")) {
            this.disengageModel();
        }
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("values", this.collectionChangeListener);
    }

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("values", this.collectionChangeListener);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.collectionHolder);
    }

    protected abstract void itemsAdded(CollectionChangeEvent var1);

    protected abstract void itemsRemoved(CollectionChangeEvent var1);

    protected abstract void collectionCleared(CollectionChangeEvent var1);

    protected abstract void collectionChanged(CollectionChangeEvent var1);
}

