/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public class CompositeCollectionValueModel
extends CollectionValueModelWrapper {
    private final Transformer transformer;
    private final IdentityHashMap components;
    private final IdentityHashMap collections;
    private final CollectionChangeListener componentListener;
    private int size;

    public CompositeCollectionValueModel(CollectionValueModel collectionHolder) {
        this(collectionHolder, Transformer.Disabled.instance());
    }

    public CompositeCollectionValueModel(CollectionValueModel collectionHolder, Transformer transformer) {
        super(collectionHolder);
        this.transformer = transformer;
        this.components = new IdentityHashMap();
        this.collections = new IdentityHashMap();
        this.componentListener = this.buildComponentListener();
        this.size = 0;
    }

    public CompositeCollectionValueModel(ListValueModel listHolder) {
        this(new ListCollectionValueModelAdapter(listHolder));
    }

    public CompositeCollectionValueModel(ListValueModel listHolder, Transformer transformer) {
        this(new ListCollectionValueModelAdapter(listHolder), transformer);
    }

    protected CollectionChangeListener buildComponentListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CompositeCollectionValueModel.this.componentItemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CompositeCollectionValueModel.this.componentItemsRemoved(e);
            }

            public void collectionCleared(CollectionChangeEvent e) {
                CompositeCollectionValueModel.this.componentCollectionCleared(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CompositeCollectionValueModel.this.componentCollectionChanged(e);
            }

            public String toString() {
                return "component listener";
            }
        };
    }

    public Iterator iterator() {
        return new CompositeIterator(this.buildCollectionsIterators());
    }

    protected Iterator buildCollectionsIterators() {
        return new TransformationIterator(this.collections.values().iterator()){

            protected Object transform(Object next) {
                return ((ArrayList)next).iterator();
            }
        };
    }

    public int size() {
        return this.size;
    }

    protected void engageModel() {
        super.engageModel();
        this.addComponentSources(this.collectionHolder.iterator());
    }

    protected void disengageModel() {
        super.disengageModel();
        Iterator stream = this.components.values().iterator();
        while (stream.hasNext()) {
            ((CollectionValueModel)stream.next()).removeCollectionChangeListener("values", this.componentListener);
        }
        this.components.clear();
        this.collections.clear();
        this.size = 0;
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        this.addComponentSources(e.items());
    }

    protected void addComponentSources(Iterator sources) {
        while (sources.hasNext()) {
            this.addComponentSource(sources.next());
        }
    }

    protected void addComponentSource(Object source) {
        CollectionValueModel component = this.transform(source);
        if (this.components.put(source, component) != null) {
            throw new IllegalStateException("duplicate component: " + source);
        }
        component.addCollectionChangeListener("values", this.componentListener);
        ArrayList componentCollection = new ArrayList(component.size());
        if (this.collections.put(component, componentCollection) != null) {
            throw new IllegalStateException("duplicate collection: " + source);
        }
        this.addComponentItems(component, componentCollection);
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        this.removeComponentSources(e.items());
    }

    protected void removeComponentSources(Iterator sources) {
        while (sources.hasNext()) {
            this.removeComponentSource(sources.next());
        }
    }

    protected void removeComponentSource(Object source) {
        CollectionValueModel component = (CollectionValueModel)this.components.remove(source);
        if (component == null) {
            throw new IllegalStateException("missing component: " + source);
        }
        component.removeCollectionChangeListener("values", this.componentListener);
        ArrayList componentCollection = (ArrayList)this.collections.remove(component);
        if (componentCollection == null) {
            throw new IllegalStateException("missing collection: " + source);
        }
        this.clearComponentItems(componentCollection);
    }

    protected void collectionCleared(CollectionChangeEvent e) {
        this.removeComponentSources(new ArrayList(this.components.keySet()).iterator());
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        this.removeComponentSources(new ArrayList(this.components.keySet()).iterator());
        this.addComponentSources(this.collectionHolder.iterator());
    }

    protected ArrayList getComponentCollection(CollectionValueModel collectionValueModel) {
        return (ArrayList)this.collections.get(collectionValueModel);
    }

    protected CollectionValueModel transform(Object value) {
        return (CollectionValueModel)this.transformer.transform(value);
    }

    protected void componentItemsAdded(CollectionChangeEvent e) {
        this.addComponentItems(e.items(), e.itemsSize(), (CollectionValueModel)e.getSource());
    }

    protected void addComponentItems(Iterator items, int itemsSize, CollectionValueModel cvm) {
        this.addComponentItems(items, itemsSize, this.getComponentCollection(cvm));
    }

    protected void addComponentItems(CollectionValueModel itemsHolder, ArrayList componentCollection) {
        this.addComponentItems(itemsHolder.iterator(), itemsHolder.size(), componentCollection);
    }

    protected void addComponentItems(Iterator items, int itemsSize, ArrayList componentCollection) {
        this.size += itemsSize;
        componentCollection.ensureCapacity(componentCollection.size() + itemsSize);
        this.addItemsToCollection(items, componentCollection, "values");
    }

    protected void componentItemsRemoved(CollectionChangeEvent e) {
        this.removeComponentItems(e.items(), e.itemsSize(), (CollectionValueModel)e.getSource());
    }

    protected void removeComponentItems(Iterator items, int itemsSize, CollectionValueModel cvm) {
        this.removeComponentItems(items, itemsSize, this.getComponentCollection(cvm));
    }

    protected void clearComponentItems(ArrayList items) {
        this.removeComponentItems(((ArrayList)items.clone()).iterator(), items.size(), items);
    }

    protected void removeComponentItems(Iterator items, int itemsSize, ArrayList componentCollection) {
        this.size -= itemsSize;
        this.removeItemsFromCollection(items, componentCollection, "values");
    }

    protected void componentCollectionCleared(CollectionChangeEvent e) {
        CollectionValueModel component = (CollectionValueModel)e.getSource();
        ArrayList items = this.getComponentCollection(component);
        this.clearComponentItems(items);
    }

    protected void componentCollectionChanged(CollectionChangeEvent e) {
        CollectionValueModel component = (CollectionValueModel)e.getSource();
        ArrayList items = this.getComponentCollection(component);
        this.clearComponentItems(items);
        this.addComponentItems(component, items);
    }
}

