/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModelWrapper;

public class ExtendedListValueModelWrapper
extends ListValueModelWrapper {
    protected final List prefix;
    protected final List suffix;

    public ExtendedListValueModelWrapper(List prefix, ListValueModel listHolder, List suffix) {
        super(listHolder);
        this.prefix = new ArrayList(prefix);
        this.suffix = new ArrayList(suffix);
    }

    public ExtendedListValueModelWrapper(Object prefix, ListValueModel listHolder, Object suffix) {
        this(Collections.singletonList(prefix), listHolder, Collections.singletonList(suffix));
    }

    public ExtendedListValueModelWrapper(List prefix, ListValueModel listHolder) {
        this(prefix, listHolder, Collections.EMPTY_LIST);
    }

    public ExtendedListValueModelWrapper(Object prefix, ListValueModel listHolder) {
        this(Collections.singletonList(prefix), listHolder, Collections.EMPTY_LIST);
    }

    public ExtendedListValueModelWrapper(ListValueModel listHolder, List suffix) {
        this(Collections.EMPTY_LIST, listHolder, suffix);
    }

    public ExtendedListValueModelWrapper(ListValueModel listHolder, Object suffix) {
        this(Collections.EMPTY_LIST, listHolder, Collections.singletonList(suffix));
    }

    public ExtendedListValueModelWrapper(ListValueModel listHolder) {
        this(Collections.singletonList(null), listHolder, Collections.EMPTY_LIST);
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return new ReadOnlyListIterator(new CompositeListIterator(this.prefix.listIterator(), this.listHolder.listIterator(), this.suffix.listIterator()));
    }

    public Object get(int index) {
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            return this.prefix.get(index);
        }
        if (index >= prefixSize + this.listHolder.size()) {
            return this.suffix.get(index - (prefixSize + this.listHolder.size()));
        }
        return this.listHolder.get(index - prefixSize);
    }

    public int size() {
        return this.prefix.size() + this.listHolder.size() + this.suffix.size();
    }

    protected void itemsAdded(ListChangeEvent e) {
        this.fireItemsAdded(e.cloneWithSource(this, "list values", this.prefix.size()));
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.fireItemsRemoved(e.cloneWithSource(this, "list values", this.prefix.size()));
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.fireItemsReplaced(e.cloneWithSource(this, "list values", this.prefix.size()));
    }

    protected void itemsMoved(ListChangeEvent e) {
        this.fireItemsMoved(e.cloneWithSource(this, "list values", this.prefix.size()));
    }

    protected void listCleared(ListChangeEvent e) {
        this.fireListCleared("list values");
    }

    protected void listChanged(ListChangeEvent e) {
        this.fireListChanged("list values");
    }

    public void toString(StringBuilder sb) {
        sb.append(this.prefix);
        sb.append(" ");
        super.toString(sb);
        sb.append(" ");
        sb.append(this.suffix);
    }
}

