/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public class FilteringCollectionValueModel
extends CollectionValueModelWrapper {
    private final Filter filter;
    private final Filter localFilter;
    private final Collection filteredItems;

    public FilteringCollectionValueModel(CollectionValueModel collectionHolder) {
        this(collectionHolder, Filter.Disabled.instance());
    }

    public FilteringCollectionValueModel(CollectionValueModel collectionHolder, Filter filter) {
        super(collectionHolder);
        this.filter = filter;
        this.localFilter = this.buildLocalFilter();
        this.filteredItems = new ArrayList();
    }

    public FilteringCollectionValueModel(ListValueModel listHolder) {
        this(new ListCollectionValueModelAdapter(listHolder));
    }

    public FilteringCollectionValueModel(ListValueModel listHolder, Filter filter) {
        this(new ListCollectionValueModelAdapter(listHolder), filter);
    }

    protected Filter buildLocalFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return FilteringCollectionValueModel.this.accept(o);
            }
        };
    }

    public Iterator iterator() {
        return this.filteredItems.iterator();
    }

    public int size() {
        return this.filteredItems.size();
    }

    protected void engageModel() {
        super.engageModel();
        this.synchFilteredItems();
    }

    protected void disengageModel() {
        super.disengageModel();
        this.filteredItems.clear();
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        this.addItemsToCollection(this.filter(e.items()), this.filteredItems, "values");
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        this.removeItemsFromCollection(e.items(), this.filteredItems, "values");
    }

    protected void collectionCleared(CollectionChangeEvent e) {
        this.clearCollection(this.filteredItems, "values");
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        this.synchFilteredItems();
        this.fireCollectionChanged("values");
    }

    protected boolean accept(Object value) {
        return this.filter.accept(value);
    }

    protected Iterator filter(Iterator items) {
        return new FilteringIterator(items, this.localFilter);
    }

    protected void synchFilteredItems() {
        this.filteredItems.clear();
        CollectionTools.addAll(this.filteredItems, this.filter(this.collectionHolder.iterator()));
    }
}

