/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.BidiFilter;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModelWrapper;

public class FilteringPropertyValueModel
extends PropertyValueModelWrapper {
    private final BidiFilter filter;
    private final Object defaultValue;

    public FilteringPropertyValueModel(PropertyValueModel valueHolder) {
        this(valueHolder, BidiFilter.Disabled.instance(), null);
    }

    public FilteringPropertyValueModel(PropertyValueModel valueHolder, Object defaultValue) {
        this(valueHolder, BidiFilter.Disabled.instance(), defaultValue);
    }

    public FilteringPropertyValueModel(PropertyValueModel valueHolder, BidiFilter filter) {
        this(valueHolder, filter, null);
    }

    public FilteringPropertyValueModel(PropertyValueModel valueHolder, BidiFilter filter, Object defaultValue) {
        super(valueHolder);
        this.filter = filter;
        this.defaultValue = defaultValue;
    }

    public Object value() {
        return this.filterValue(this.valueHolder.value());
    }

    public void setValue(Object value) {
        if (this.reverseAccept(value)) {
            this.valueHolder.setValue(value);
        }
    }

    protected void valueChanged(PropertyChangeEvent e) {
        Object oldValue = this.filterValue(e.oldValue());
        Object newValue = this.filterValue(e.newValue());
        this.firePropertyChanged("value", oldValue, newValue);
    }

    protected Object filterValue(Object value) {
        return this.accept(value) ? value : this.defaultValue();
    }

    protected boolean accept(Object value) {
        return this.filter.accept(value);
    }

    protected boolean reverseAccept(Object value) {
        return this.filter.reverseAccept(value);
    }

    protected Object defaultValue() {
        return this.defaultValue;
    }
}

