/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.Counter;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModelWrapper;

public abstract class ItemAspectListValueModelAdapter
extends ListValueModelWrapper {
    protected final IdentityHashMap counters = new IdentityHashMap();

    protected ItemAspectListValueModelAdapter(ListValueModel listHolder) {
        super(listHolder);
    }

    protected ItemAspectListValueModelAdapter(CollectionValueModel collectionHolder) {
        this(new CollectionListValueModelAdapter(collectionHolder));
    }

    public ListIterator listIterator() {
        return this.listHolder.listIterator();
    }

    public Object get(int index) {
        return this.listHolder.get(index);
    }

    public int size() {
        return this.listHolder.size();
    }

    protected void engageModel() {
        super.engageModel();
        this.engageAllItems();
    }

    protected void engageAllItems() {
        this.engageItems(this.listHolder.iterator());
    }

    protected void engageItems(Iterator stream) {
        while (stream.hasNext()) {
            this.engageItem(stream.next());
        }
    }

    protected void engageItem(Object item) {
        Counter counter = (Counter)this.counters.get(item);
        if (counter == null) {
            counter = new Counter();
            this.counters.put(item, counter);
            this.startListeningToItem((Model)item);
        }
        counter.increment();
    }

    protected abstract void startListeningToItem(Model var1);

    protected void disengageModel() {
        this.disengageAllItems();
        super.disengageModel();
    }

    protected void disengageAllItems() {
        this.disengageItems(this.listHolder.iterator());
    }

    protected void disengageItems(Iterator stream) {
        while (stream.hasNext()) {
            this.disengageItem(stream.next());
        }
    }

    protected void disengageItem(Object item) {
        Counter counter = (Counter)this.counters.get(item);
        if (counter == null) {
            throw new IllegalStateException("missing counter: " + item);
        }
        if (counter.decrement() == 0) {
            this.counters.remove(item);
            this.stopListeningToItem((Model)item);
        }
    }

    protected abstract void stopListeningToItem(Model var1);

    protected void itemsAdded(ListChangeEvent e) {
        this.fireItemsAdded(e.cloneWithSource(this, "list values"));
        this.engageItems(e.items());
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.disengageItems(e.items());
        this.fireItemsRemoved(e.cloneWithSource(this, "list values"));
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.disengageItems(e.replacedItems());
        this.fireItemsReplaced(e.cloneWithSource(this, "list values"));
        this.engageItems(e.items());
    }

    protected void itemsMoved(ListChangeEvent e) {
        this.fireItemsMoved(e.cloneWithSource(this, "list values"));
    }

    protected void listCleared(ListChangeEvent e) {
        ArrayList keys = new ArrayList(this.counters.keySet());
        this.disengageItems(keys.iterator());
        this.counters.clear();
        this.fireListCleared("list values");
    }

    protected void listChanged(ListChangeEvent e) {
        ArrayList keys = new ArrayList(this.counters.keySet());
        this.disengageItems(keys.iterator());
        this.counters.clear();
        this.fireListChanged("list values");
        this.engageAllItems();
    }

    protected void itemAspectChanged(EventObject e) {
        Object item = e.getSource();
        int index = this.lastIdentityIndexOf(item);
        while (index != -1) {
            this.itemAspectChanged(index, item);
            index = this.lastIdentityIndexOf(item, index);
        }
    }

    protected void itemAspectChanged(int index, Object item) {
        this.fireItemReplaced("list values", index, item, item);
    }

    protected int lastIdentityIndexOf(Object o) {
        return this.lastIdentityIndexOf(o, this.listHolder.size());
    }

    protected int lastIdentityIndexOf(Object o, int end) {
        int i = end;
        while (i-- > 0) {
            if (this.listHolder.get(i) != o) continue;
            return i;
        }
        return -1;
    }
}

