/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemAspectListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public class ItemCollectionListValueModelAdapter
extends ItemAspectListValueModelAdapter {
    protected final String[] collectionNames;
    protected final CollectionChangeListener itemCollectionListener;

    public ItemCollectionListValueModelAdapter(ListValueModel listHolder, String collectionName) {
        this(listHolder, new String[]{collectionName});
    }

    public ItemCollectionListValueModelAdapter(ListValueModel listHolder, String collectionName1, String collectionName2) {
        this(listHolder, new String[]{collectionName1, collectionName2});
    }

    public ItemCollectionListValueModelAdapter(ListValueModel listHolder, String collectionName1, String collectionName2, String collectionName3) {
        this(listHolder, new String[]{collectionName1, collectionName2, collectionName3});
    }

    public ItemCollectionListValueModelAdapter(ListValueModel listHolder, String[] collectionNames) {
        super(listHolder);
        this.collectionNames = collectionNames;
        this.itemCollectionListener = this.buildItemCollectionListener();
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionHolder, String collectionName) {
        this(collectionHolder, new String[]{collectionName});
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionHolder, String collectionName1, String collectionName2) {
        this(collectionHolder, new String[]{collectionName1, collectionName2});
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionHolder, String collectionName1, String collectionName2, String collectionName3) {
        this(collectionHolder, new String[]{collectionName1, collectionName2, collectionName3});
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionHolder, String[] collectionNames) {
        this((ListValueModel)new CollectionListValueModelAdapter(collectionHolder), collectionNames);
    }

    protected CollectionChangeListener buildItemCollectionListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged(e);
            }

            public void collectionCleared(CollectionChangeEvent e) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged(e);
            }

            public String toString() {
                return "item collection listener: " + Arrays.asList(ItemCollectionListValueModelAdapter.this.collectionNames);
            }
        };
    }

    protected void startListeningToItem(Model item) {
        int i = this.collectionNames.length;
        while (i-- > 0) {
            item.addCollectionChangeListener(this.collectionNames[i], this.itemCollectionListener);
        }
    }

    protected void stopListeningToItem(Model item) {
        int i = this.collectionNames.length;
        while (i-- > 0) {
            item.removeCollectionChangeListener(this.collectionNames[i], this.itemCollectionListener);
        }
    }
}

