/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemAspectListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public class ItemListListValueModelAdapter
extends ItemAspectListValueModelAdapter {
    protected final String[] listNames;
    protected final ListChangeListener itemListListener;

    public ItemListListValueModelAdapter(ListValueModel listHolder, String listName) {
        this(listHolder, new String[]{listName});
    }

    public ItemListListValueModelAdapter(ListValueModel listHolder, String listName1, String listName2) {
        this(listHolder, new String[]{listName1, listName2});
    }

    public ItemListListValueModelAdapter(ListValueModel listHolder, String listName1, String listName2, String listName3) {
        this(listHolder, new String[]{listName1, listName2, listName3});
    }

    public ItemListListValueModelAdapter(ListValueModel listHolder, String[] listNames) {
        super(listHolder);
        this.listNames = listNames;
        this.itemListListener = this.buildItemListListener();
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionHolder, String listName) {
        this(collectionHolder, new String[]{listName});
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionHolder, String listName1, String listName2) {
        this(collectionHolder, new String[]{listName1, listName2});
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionHolder, String listName1, String listName2, String listName3) {
        this(collectionHolder, new String[]{listName1, listName2, listName3});
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionHolder, String[] listNames) {
        this((ListValueModel)new CollectionListValueModelAdapter(collectionHolder), listNames);
    }

    protected ListChangeListener buildItemListListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged(e);
            }

            public void listCleared(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged(e);
            }

            public void listChanged(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged(e);
            }

            public String toString() {
                return "item list listener: " + Arrays.asList(ItemListListValueModelAdapter.this.listNames);
            }
        };
    }

    protected void startListeningToItem(Model item) {
        int i = this.listNames.length;
        while (i-- > 0) {
            item.addListChangeListener(this.listNames[i], this.itemListListener);
        }
    }

    protected void stopListeningToItem(Model item) {
        int i = this.listNames.length;
        while (i-- > 0) {
            item.removeListChangeListener(this.listNames[i], this.itemListListener);
        }
    }
}

