/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemAspectListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public class ItemPropertyListValueModelAdapter
extends ItemAspectListValueModelAdapter {
    protected final String[] propertyNames;
    protected final PropertyChangeListener itemPropertyListener;

    public ItemPropertyListValueModelAdapter(ListValueModel listHolder, String propertyName) {
        this(listHolder, new String[]{propertyName});
    }

    public ItemPropertyListValueModelAdapter(ListValueModel listHolder, String propertyName1, String propertyName2) {
        this(listHolder, new String[]{propertyName1, propertyName2});
    }

    public ItemPropertyListValueModelAdapter(ListValueModel listHolder, String propertyName1, String propertyName2, String propertyName3) {
        this(listHolder, new String[]{propertyName1, propertyName2, propertyName3});
    }

    public ItemPropertyListValueModelAdapter(ListValueModel listHolder, String[] propertyNames) {
        super(listHolder);
        this.propertyNames = propertyNames;
        this.itemPropertyListener = this.buildItemPropertyListener();
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionHolder, String propertyName) {
        this(collectionHolder, new String[]{propertyName});
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionHolder, String propertyName1, String propertyName2) {
        this(collectionHolder, new String[]{propertyName1, propertyName2});
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionHolder, String propertyName1, String propertyName2, String propertyName3) {
        this(collectionHolder, new String[]{propertyName1, propertyName2, propertyName3});
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionHolder, String[] propertyNames) {
        this((ListValueModel)new CollectionListValueModelAdapter(collectionHolder), propertyNames);
    }

    protected PropertyChangeListener buildItemPropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                ItemPropertyListValueModelAdapter.this.itemAspectChanged(e);
            }

            public String toString() {
                return "item property listener: " + Arrays.asList(ItemPropertyListValueModelAdapter.this.propertyNames);
            }
        };
    }

    protected void startListeningToItem(Model item) {
        int i = this.propertyNames.length;
        while (i-- > 0) {
            item.addPropertyChangeListener(this.propertyNames[i], this.itemPropertyListener);
        }
    }

    protected void stopListeningToItem(Model item) {
        int i = this.propertyNames.length;
        while (i-- > 0) {
            item.removePropertyChangeListener(this.propertyNames[i], this.itemPropertyListener);
        }
    }
}

