/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListAspectAdapter
extends AspectAdapter
implements ListValueModel {
    protected final String listName;
    protected final ListChangeListener listChangeListener;

    protected ListAspectAdapter(String listName, Model subject) {
        this(new ReadOnlyPropertyValueModel(subject), listName);
    }

    protected ListAspectAdapter(ValueModel subjectHolder) {
        this(subjectHolder, null);
    }

    protected ListAspectAdapter(ValueModel subjectHolder, String listName) {
        super(subjectHolder);
        this.listName = listName;
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ListAspectAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ListAspectAdapter.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ListAspectAdapter.this.itemsReplaced(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                ListAspectAdapter.this.itemsMoved(e);
            }

            public void listCleared(ListChangeEvent e) {
                ListAspectAdapter.this.listCleared(e);
            }

            public void listChanged(ListChangeEvent e) {
                ListAspectAdapter.this.listChanged(e);
            }

            public String toString() {
                return "list change listener: " + ListAspectAdapter.this.listName;
            }
        };
    }

    @Override
    public Iterator iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator listIterator() {
        if (this.subject == null) {
            return EmptyListIterator.instance();
        }
        return this.getValueFromSubject();
    }

    protected ListIterator getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(int index) {
        return CollectionTools.get((ListIterator)this.value(), index);
    }

    @Override
    public int size() {
        return this.subject == null ? 0 : this.sizeFromSubject();
    }

    protected int sizeFromSubject() {
        return CollectionTools.size((ListIterator)this.value());
    }

    @Override
    protected Object value() {
        return this.iterator();
    }

    @Override
    protected Class<? extends ChangeListener> listenerClass() {
        return ListChangeListener.class;
    }

    @Override
    protected String listenerAspectName() {
        return "list values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireListChanged("list values");
    }

    @Override
    protected void engageNonNullSubject() {
        if (this.listName != null) {
            ((Model)this.subject).addListChangeListener(this.listName, this.listChangeListener);
        }
    }

    @Override
    protected void disengageNonNullSubject() {
        if (this.listName != null) {
            ((Model)this.subject).removeListChangeListener(this.listName, this.listChangeListener);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.listName);
    }

    protected void itemsAdded(ListChangeEvent e) {
        this.fireItemsAdded(e.cloneWithSource(this, "list values"));
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.fireItemsRemoved(e.cloneWithSource(this, "list values"));
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.fireItemsReplaced(e.cloneWithSource(this, "list values"));
    }

    protected void itemsMoved(ListChangeEvent e) {
        this.fireItemsMoved(e.cloneWithSource(this, "list values"));
    }

    protected void listCleared(ListChangeEvent e) {
        this.fireListCleared("list values");
    }

    protected void listChanged(ListChangeEvent e) {
        this.fireListChanged("list values");
    }
}

