/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public class ListCollectionValueModelAdapter
extends AbstractModel
implements CollectionValueModel {
    protected final ListValueModel listHolder;
    protected final ListChangeListener listChangeListener;
    protected final ArrayList collection;

    public ListCollectionValueModelAdapter(ListValueModel listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.listChangeListener = this.buildListChangeListener();
        this.collection = new ArrayList();
    }

    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, CollectionChangeListener.class, "values");
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.itemsReplaced(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.itemsMoved(e);
            }

            public void listCleared(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.listCleared(e);
            }

            public void listChanged(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.listChanged(e);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    public Iterator iterator() {
        return new ReadOnlyIterator(this.collection);
    }

    public int size() {
        return this.collection.size();
    }

    public void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(listener);
    }

    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "values" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "values" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("values");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected int lastIdentityIndexOf(Object o) {
        return this.lastIdentityIndexOf(o, this.collection.size());
    }

    protected int lastIdentityIndexOf(Object o, int end) {
        int i = end;
        while (i-- > 0) {
            if (this.collection.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    protected void buildCollection() {
        Iterator stream = this.listHolder.iterator();
        if (stream.hasNext()) {
            this.collection.ensureCapacity(this.listHolder.size());
            while (stream.hasNext()) {
                this.collection.add(stream.next());
            }
        }
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
        this.buildCollection();
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
        this.collection.clear();
    }

    protected void itemsAdded(ListChangeEvent e) {
        this.addItemsToCollection(e.items(), this.collection, "values");
    }

    protected void removeInternalItems(Iterator items) {
        while (items.hasNext()) {
            Object removedItem = items.next();
            int index = this.lastIdentityIndexOf(removedItem);
            this.collection.remove(index);
            this.fireItemRemoved("values", removedItem);
        }
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.removeInternalItems(e.items());
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.removeInternalItems(e.replacedItems());
        this.addItemsToCollection(e.items(), this.collection, "values");
    }

    protected void itemsMoved(ListChangeEvent e) {
    }

    protected void listCleared(ListChangeEvent e) {
        if (!this.collection.isEmpty()) {
            this.collection.clear();
            this.fireCollectionCleared("values");
        }
    }

    protected void listChanged(ListChangeEvent e) {
        if (!this.collection.isEmpty()) {
            ArrayList removedItems = (ArrayList)this.collection.clone();
            this.collection.clear();
            this.fireItemsRemoved("values", removedItems);
        }
        this.buildCollection();
        if (!this.collection.isEmpty()) {
            this.fireItemsAdded("values", this.collection);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.listHolder);
    }
}

