/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListCurator
extends AspectAdapter
implements ListValueModel {
    private final ArrayList record = new ArrayList();
    private final StateChangeListener stateChangeListener = this.buildStateChangeListener();

    protected ListCurator(Model subject) {
        this(new ReadOnlyPropertyValueModel(subject));
    }

    protected ListCurator(ValueModel subjectHolder) {
        super(subjectHolder);
    }

    protected StateChangeListener buildStateChangeListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent e) {
                ListCurator.this.submitInventoryReport();
            }

            public String toString() {
                return "state change listener";
            }
        };
    }

    @Override
    public Iterator iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator listIterator() {
        return new ReadOnlyListIterator(this.record);
    }

    @Override
    public Object get(int index) {
        return this.record.get(index);
    }

    @Override
    public int size() {
        return this.record.size();
    }

    @Override
    protected Object value() {
        return this.iterator();
    }

    @Override
    protected Class<? extends ChangeListener> listenerClass() {
        return ListChangeListener.class;
    }

    @Override
    protected String listenerAspectName() {
        return "list values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireListChanged("list values");
    }

    @Override
    protected void engageNonNullSubject() {
        ((Model)this.subject).addStateChangeListener(this.stateChangeListener);
        CollectionTools.addAll(this.record, this.getValueForRecord());
    }

    @Override
    protected void disengageNonNullSubject() {
        ((Model)this.subject).removeStateChangeListener(this.stateChangeListener);
        this.record.clear();
    }

    protected abstract Iterator getValueForRecord();

    void submitInventoryReport() {
        List newRecord = CollectionTools.list(this.getValueForRecord());
        int recordIndex = 0;
        Iterator newItems = newRecord.iterator();
        while (newItems.hasNext()) {
            this.inventoryNewItem(recordIndex, newItems.next());
            ++recordIndex;
        }
        recordIndex = 0;
        while (recordIndex < this.record.size()) {
            Object item = this.record.get(recordIndex);
            if (!newRecord.contains(item)) {
                this.removeItemFromInventory(recordIndex, item);
                continue;
            }
            ++recordIndex;
        }
    }

    private void inventoryNewItem(int recordIndex, Object newItem) {
        ArrayList rec = new ArrayList(this.record);
        if (recordIndex < rec.size() && rec.get(recordIndex).equals(newItem)) {
            return;
        }
        if (!rec.contains(newItem)) {
            this.addItemToInventory(recordIndex, newItem);
        } else {
            this.removeItemFromInventory(recordIndex, rec.get(recordIndex));
            this.inventoryNewItem(recordIndex, newItem);
        }
    }

    private void addItemToInventory(int index, Object item) {
        this.addItemToList(index, item, this.record, "list values");
    }

    private void removeItemFromInventory(int index, Object item) {
        this.removeItemFromList(index, this.record, "list values");
    }
}

