/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public abstract class ListValueModelWrapper
extends AbstractModel
implements ListValueModel {
    protected final ListValueModel listHolder;
    protected final ListChangeListener listChangeListener;

    protected ListValueModelWrapper(ListValueModel listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, ListChangeListener.class, "list values");
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ListValueModelWrapper.this.itemsAdded(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ListValueModelWrapper.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ListValueModelWrapper.this.itemsReplaced(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                ListValueModelWrapper.this.itemsMoved(e);
            }

            public void listCleared(ListChangeEvent e) {
                ListValueModelWrapper.this.listCleared(e);
            }

            public void listChanged(ListChangeEvent e) {
                ListValueModelWrapper.this.listChanged(e);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public synchronized void addListChangeListener(ListChangeListener listener) {
        if (this.hasNoListChangeListeners("list values")) {
            this.engageModel();
        }
        super.addListChangeListener(listener);
    }

    public synchronized void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName == "list values" && this.hasNoListChangeListeners("list values")) {
            this.engageModel();
        }
        super.addListChangeListener(listName, listener);
    }

    public synchronized void removeListChangeListener(ListChangeListener listener) {
        super.removeListChangeListener(listener);
        if (this.hasNoListChangeListeners("list values")) {
            this.disengageModel();
        }
    }

    public synchronized void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName == "list values" && this.hasNoListChangeListeners("list values")) {
            this.disengageModel();
        }
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.listHolder);
    }

    protected abstract void itemsAdded(ListChangeEvent var1);

    protected abstract void itemsRemoved(ListChangeEvent var1);

    protected abstract void itemsReplaced(ListChangeEvent var1);

    protected abstract void itemsMoved(ListChangeEvent var1);

    protected abstract void listCleared(ListChangeEvent var1);

    protected abstract void listChanged(ListChangeEvent var1);
}

