/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyAspectAdapter
extends AspectAdapter
implements PropertyValueModel {
    protected Object value;
    protected final String[] propertyNames;
    private static final String[] EMPTY_PROPERTY_NAMES = new String[0];
    protected final PropertyChangeListener propertyChangeListener;

    protected PropertyAspectAdapter(String propertyName, Model subject) {
        this(new String[]{propertyName}, subject);
    }

    protected PropertyAspectAdapter(String[] propertyNames, Model subject) {
        this((ValueModel)new ReadOnlyPropertyValueModel(subject), propertyNames);
    }

    protected PropertyAspectAdapter(ValueModel subjectHolder, String ... propertyNames) {
        super(subjectHolder);
        this.propertyNames = propertyNames;
        this.propertyChangeListener = this.buildPropertyChangeListener();
        this.value = null;
    }

    protected PropertyAspectAdapter(ValueModel subjectHolder, Collection<String> propertyNames) {
        this(subjectHolder, propertyNames.toArray(new String[propertyNames.size()]));
    }

    protected PropertyAspectAdapter(ValueModel subjectHolder) {
        this(subjectHolder, EMPTY_PROPERTY_NAMES);
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                PropertyAspectAdapter.this.propertyChanged();
            }

            public String toString() {
                return "property change listener: " + Arrays.asList(PropertyAspectAdapter.this.propertyNames);
            }
        };
    }

    @Override
    public final Object value() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (this.subject != null) {
            this.setValueOnSubject(value);
        }
    }

    protected void setValueOnSubject(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Class<? extends ChangeListener> listenerClass() {
        return PropertyChangeListener.class;
    }

    @Override
    protected String listenerAspectName() {
        return "value";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.firePropertyChanged("value", oldValue, newValue);
    }

    @Override
    protected void engageSubject() {
        super.engageSubject();
        this.value = this.buildValue();
    }

    @Override
    protected void engageNonNullSubject() {
        int i = this.propertyNames.length;
        while (i-- > 0) {
            ((Model)this.subject).addPropertyChangeListener(this.propertyNames[i], this.propertyChangeListener);
        }
    }

    @Override
    protected void disengageSubject() {
        super.disengageSubject();
        this.value = null;
    }

    @Override
    protected void disengageNonNullSubject() {
        int i = this.propertyNames.length;
        while (i-- > 0) {
            ((Model)this.subject).removePropertyChangeListener(this.propertyNames[i], this.propertyChangeListener);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        int i = 0;
        while (i < this.propertyNames.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.propertyNames[i]);
            ++i;
        }
    }

    protected Object buildValue() {
        if (this.subject == null) {
            return null;
        }
        return this.getValueFromSubject();
    }

    protected Object getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    protected void propertyChanged() {
        Object old = this.value;
        this.value = this.buildValue();
        this.fireAspectChange(old, this.value);
    }
}

