/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;

public class PropertyCollectionValueModelAdapter
extends AbstractModel
implements CollectionValueModel {
    protected final PropertyValueModel valueHolder;
    protected final PropertyChangeListener propertyChangeListener;
    protected Object value;

    public PropertyCollectionValueModelAdapter(PropertyValueModel valueHolder) {
        if (valueHolder == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.propertyChangeListener = this.buildPropertyChangeListener();
    }

    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, CollectionChangeListener.class, "values");
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                PropertyCollectionValueModelAdapter.this.valueChanged(e.newValue());
            }

            public String toString() {
                return "property change listener";
            }
        };
    }

    public Iterator iterator() {
        return this.value == null ? EmptyIterator.instance() : new SingleElementIterator<Object>(this.value);
    }

    public int size() {
        return this.value == null ? 0 : 1;
    }

    public void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(listener);
    }

    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "values" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "values" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("values");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected void engageModel() {
        this.valueHolder.addPropertyChangeListener("value", this.propertyChangeListener);
        this.value = this.valueHolder.value();
    }

    protected void disengageModel() {
        this.valueHolder.removePropertyChangeListener("value", this.propertyChangeListener);
        this.value = null;
    }

    protected void valueChanged(Object newValue) {
        if (this.value != null) {
            Object oldValue = this.value;
            this.value = null;
            this.fireItemRemoved("values", oldValue);
        }
        this.value = newValue;
        if (this.value != null) {
            this.fireItemAdded("values", this.value);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.valueHolder);
    }
}

