/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;

public abstract class PropertyValueModelWrapper
extends AbstractModel
implements PropertyValueModel {
    protected final PropertyValueModel valueHolder;
    protected final PropertyChangeListener valueChangeListener;

    protected PropertyValueModelWrapper(PropertyValueModel valueHolder) {
        if (valueHolder == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.valueChangeListener = this.buildValueChangeListener();
    }

    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, PropertyChangeListener.class, "value");
    }

    protected PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                PropertyValueModelWrapper.this.valueChanged(e);
            }

            public String toString() {
                return "value change listener";
            }
        };
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (propertyName == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    protected void engageValueHolder() {
        this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
    }

    protected void disengageValueHolder() {
        this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.valueHolder);
    }

    protected abstract void valueChanged(PropertyChangeEvent var1);
}

