/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCollectionValueModel<E>
extends AbstractModel
implements CollectionValueModel,
Collection<E> {
    protected Collection<E> collection;

    public SimpleCollectionValueModel(Collection<E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        this.collection = collection;
    }

    public SimpleCollectionValueModel() {
        this(new HashBag());
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, CollectionChangeListener.class, "values");
    }

    @Override
    public Iterator<E> iterator() {
        return new LocalIterator<E>(this.collection.iterator());
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collection.toArray(a);
    }

    @Override
    public boolean add(E o) {
        return this.addItemToCollection(o, this.collection, "values");
    }

    @Override
    public boolean remove(Object o) {
        return this.removeItemFromCollection(o, this.collection, "values");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addItemsToCollection(c, this.collection, "values");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeItemsFromCollection(c, this.collection, "values");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.retainItemsInCollection(c, this.collection, "values");
    }

    @Override
    public void clear() {
        if (this.collection.isEmpty()) {
            return;
        }
        ArrayList<E> items = new ArrayList<E>(this.collection);
        this.collection.clear();
        this.fireItemsRemoved("values", items);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Collection && o instanceof CollectionValueModel) {
            Collection<E> c1 = CollectionTools.collection(this.collection);
            Collection c2 = CollectionTools.collection(((Collection)o).iterator());
            return c1.equals(c2);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return CollectionTools.collection(this.collection).hashCode();
    }

    public void setCollection(Collection<E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        this.collection = collection;
        this.fireCollectionChanged("values");
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.collection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private T next;

        LocalIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.next = this.iterator.next();
            return this.next;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            SimpleCollectionValueModel.this.fireItemRemoved("values", this.next);
        }
    }
}

