/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModelWrapper;

public class TransformationListValueModelAdapter
extends ListValueModelWrapper {
    protected final Transformer transformer;
    protected final List transformedList;

    public TransformationListValueModelAdapter(ListValueModel listHolder, Transformer transformer) {
        super(listHolder);
        this.transformer = transformer;
        this.transformedList = new ArrayList();
    }

    public TransformationListValueModelAdapter(ListValueModel listHolder) {
        this(listHolder, Transformer.Disabled.instance());
    }

    public TransformationListValueModelAdapter(CollectionValueModel collectionHolder, Transformer transformer) {
        this(new CollectionListValueModelAdapter(collectionHolder), transformer);
    }

    public TransformationListValueModelAdapter(CollectionValueModel collectionHolder) {
        this(collectionHolder, Transformer.Disabled.instance());
    }

    public ListIterator listIterator() {
        return new ReadOnlyListIterator(this.transformedList);
    }

    public Object get(int index) {
        return this.transformedList.get(index);
    }

    public int size() {
        return this.transformedList.size();
    }

    protected void engageModel() {
        super.engageModel();
        this.transformedList.addAll(this.transformItems(this.listHolder));
    }

    protected void disengageModel() {
        super.disengageModel();
        this.transformedList.clear();
    }

    protected List transformItems(ListChangeEvent e) {
        return this.transformItems(e.items(), e.itemsSize());
    }

    protected List transformItems(ListValueModel lvm) {
        return this.transformItems(lvm.listIterator(), lvm.size());
    }

    protected List transformReplacedItems(ListChangeEvent e) {
        return this.transformItems(e.replacedItems(), e.itemsSize());
    }

    protected List transformItems(ListIterator items, int size) {
        ArrayList<Object> result = new ArrayList<Object>(size);
        while (items.hasNext()) {
            result.add(this.transformItem(items.next()));
        }
        return result;
    }

    protected Object transformItem(Object item) {
        return this.transformer.transform(item);
    }

    protected void itemsAdded(ListChangeEvent e) {
        this.addItemsToList(e.index(), this.transformItems(e), this.transformedList, "list values");
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.removeItemsFromList(e.index(), e.itemsSize(), this.transformedList, "list values");
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.setItemsInList(e.index(), this.transformItems(e), this.transformedList, "list values");
    }

    protected void itemsMoved(ListChangeEvent e) {
        this.moveItemsInList(e.targetIndex(), e.sourceIndex(), e.moveLength(), this.transformedList, "list values");
    }

    protected void listCleared(ListChangeEvent e) {
        this.clearList(this.transformedList, "list values");
    }

    protected void listChanged(ListChangeEvent e) {
        this.transformedList.clear();
        this.transformedList.addAll(this.transformItems(this.listHolder));
        this.fireListChanged("list values");
    }
}

