/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.TreeChangeListener;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TreeValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeAspectAdapter
extends AspectAdapter
implements TreeValueModel {
    protected final String treeName;
    protected final TreeChangeListener treeChangeListener;

    protected TreeAspectAdapter(String treeName, Model subject) {
        this(new ReadOnlyPropertyValueModel(subject), treeName);
    }

    protected TreeAspectAdapter(ValueModel subjectHolder, String treeName) {
        super(subjectHolder);
        this.treeName = treeName;
        this.treeChangeListener = this.buildTreeChangeListener();
    }

    protected TreeChangeListener buildTreeChangeListener() {
        return new TreeChangeListener(){

            public void nodeAdded(TreeChangeEvent e) {
                TreeAspectAdapter.this.nodeAdded(e);
            }

            public void nodeRemoved(TreeChangeEvent e) {
                TreeAspectAdapter.this.nodeRemoved(e);
            }

            public void treeCleared(TreeChangeEvent e) {
                TreeAspectAdapter.this.treeCleared(e);
            }

            public void treeChanged(TreeChangeEvent e) {
                TreeAspectAdapter.this.treeChanged(e);
            }

            public String toString() {
                return "tree change listener: " + TreeAspectAdapter.this.treeName;
            }
        };
    }

    @Override
    public Iterator nodes() {
        if (this.subject == null) {
            return EmptyIterator.instance();
        }
        return this.getValueFromSubject();
    }

    protected Iterator getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Object[] parentPath, Object node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Object[] path) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object value() {
        return this.nodes();
    }

    @Override
    protected Class<? extends ChangeListener> listenerClass() {
        return TreeChangeListener.class;
    }

    @Override
    protected String listenerAspectName() {
        return "nodes";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyTreeChangeListeners("nodes");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireTreeChanged("nodes");
    }

    @Override
    protected void engageNonNullSubject() {
        ((Model)this.subject).addTreeChangeListener(this.treeName, this.treeChangeListener);
    }

    @Override
    protected void disengageNonNullSubject() {
        ((Model)this.subject).removeTreeChangeListener(this.treeName, this.treeChangeListener);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.treeName);
    }

    protected void nodeAdded(TreeChangeEvent e) {
        this.fireNodeAdded("nodes", e.path());
    }

    protected void nodeRemoved(TreeChangeEvent e) {
        this.fireNodeRemoved("nodes", e.path());
    }

    protected void treeCleared(TreeChangeEvent e) {
        this.fireTreeCleared("nodes");
    }

    protected void treeChanged(TreeChangeEvent e) {
        this.fireTreeChanged("nodes", e.path());
    }
}

