/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueAspectPropertyValueModelAdapter;

public class ValueListPropertyValueModelAdapter
extends ValueAspectPropertyValueModelAdapter {
    protected final String[] listNames;
    protected final ListChangeListener valueListListener;

    public ValueListPropertyValueModelAdapter(PropertyValueModel valueHolder, String listName) {
        this(valueHolder, new String[]{listName});
    }

    public ValueListPropertyValueModelAdapter(PropertyValueModel valueHolder, String listName1, String listName2) {
        this(valueHolder, new String[]{listName1, listName2});
    }

    public ValueListPropertyValueModelAdapter(PropertyValueModel valueHolder, String listName1, String listName2, String listName3) {
        this(valueHolder, new String[]{listName1, listName2, listName3});
    }

    public ValueListPropertyValueModelAdapter(PropertyValueModel valueHolder, String[] listNames) {
        super(valueHolder);
        this.listNames = listNames;
        this.valueListListener = this.buildValueListListener();
    }

    protected ListChangeListener buildValueListListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void itemsRemoved(ListChangeEvent e) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void itemsReplaced(ListChangeEvent e) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void itemsMoved(ListChangeEvent e) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void listCleared(ListChangeEvent e) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void listChanged(ListChangeEvent e) {
                ValueListPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public String toString() {
                return "value list listener: " + Arrays.asList(ValueListPropertyValueModelAdapter.this.listNames);
            }
        };
    }

    protected void startListeningToValue() {
        Model v = (Model)this.value;
        int i = this.listNames.length;
        while (i-- > 0) {
            v.addListChangeListener(this.listNames[i], this.valueListListener);
        }
    }

    protected void stopListeningToValue() {
        Model v = (Model)this.value;
        int i = this.listNames.length;
        while (i-- > 0) {
            v.removeListChangeListener(this.listNames[i], this.valueListListener);
        }
    }
}

