/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.prefs;

import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.jpt.utility.internal.BidiStringConverter;
import org.eclipse.jpt.utility.internal.model.listener.ChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencePropertyValueModel
extends AspectAdapter
implements PropertyValueModel {
    protected final String key;
    protected Object value;
    protected final Object defaultValue;
    protected BidiStringConverter converter;
    protected final PreferenceChangeListener preferenceChangeListener;

    public PreferencePropertyValueModel(Preferences preferences, String key) {
        this(preferences, key, null);
    }

    public PreferencePropertyValueModel(Preferences preferences, String key, Object defaultValue) {
        this(new ReadOnlyPropertyValueModel(preferences), key, defaultValue);
    }

    public PreferencePropertyValueModel(Preferences preferences, String key, boolean defaultValue) {
        this(preferences, key, (Object)(defaultValue ? Boolean.TRUE : Boolean.FALSE));
    }

    public PreferencePropertyValueModel(Preferences preferences, String key, int defaultValue) {
        this(preferences, key, (Object)new Integer(defaultValue));
    }

    public PreferencePropertyValueModel(ValueModel preferencesHolder, String key) {
        this(preferencesHolder, key, null);
    }

    public PreferencePropertyValueModel(ValueModel preferencesHolder, String key, Object defaultValue) {
        super(preferencesHolder);
        this.key = key;
        this.defaultValue = defaultValue;
        this.converter = BidiStringConverter.Default.instance();
        this.preferenceChangeListener = this.buildPreferenceChangeListener();
        this.value = null;
    }

    protected PreferenceChangeListener buildPreferenceChangeListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent e) {
                PreferencePropertyValueModel.this.preferenceChanged(e.getKey(), e.getNewValue());
            }

            public String toString() {
                return "preference change listener";
            }
        };
    }

    @Override
    public synchronized Object value() {
        return this.value;
    }

    @Override
    public synchronized void setValue(Object value) {
        if (this.hasNoListeners()) {
            return;
        }
        Object old = this.value;
        this.value = value;
        this.fireAspectChange(old, value);
        if (this.subject != null && this.shouldSetPreference(old, value)) {
            this.setValueOnSubject(value);
        }
    }

    @Override
    protected Class<? extends ChangeListener> listenerClass() {
        return PropertyChangeListener.class;
    }

    @Override
    protected String listenerAspectName() {
        return "value";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.firePropertyChanged("value", oldValue, newValue);
    }

    @Override
    protected void engageNonNullSubject() {
        ((Preferences)this.subject).addPreferenceChangeListener(this.preferenceChangeListener);
        this.value = this.buildValue();
    }

    @Override
    protected void disengageNonNullSubject() {
        block2: {
            try {
                ((Preferences)this.subject).removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().equals("Node has been removed.")) break block2;
                throw ex;
            }
        }
        this.value = null;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.key);
        sb.append(" => ");
        sb.append(this.value);
    }

    public String getKey() {
        return this.key;
    }

    public synchronized BidiStringConverter getConverter() {
        return this.converter;
    }

    public synchronized void setConverter(BidiStringConverter converter) {
        this.converter = converter;
    }

    protected Object buildValue() {
        if (this.subject == null) {
            return null;
        }
        return this.getValueFromSubject();
    }

    protected Object getValueFromSubject() {
        return this.convertToObject(((Preferences)this.subject).get(this.key, this.convertToString(this.defaultValue)));
    }

    protected void setValueOnSubject(Object value) {
        ((Preferences)this.subject).put(this.key, this.convertToString(value));
    }

    protected boolean shouldSetPreference(Object oldValue, Object newValue) {
        return this.attributeValueHasChanged(oldValue, newValue);
    }

    protected String convertToString(Object o) {
        return this.converter.convertToString(o);
    }

    protected Object convertToObject(String s) {
        return this.converter.convertToObject(s);
    }

    protected void preferenceChanged(String prefKey, String newValue) {
        if (prefKey.equals(this.key)) {
            this.preferenceChanged();
        }
    }

    protected synchronized void preferenceChanged() {
        Object old = this.value;
        this.value = this.buildValue();
        this.fireAspectChange(old, this.value);
    }
}

