/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.prefs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.listener.ChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueModel;
import org.eclipse.jpt.utility.internal.model.value.prefs.PreferencePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesCollectionValueModel
extends AspectAdapter
implements CollectionValueModel {
    protected final Map preferences = new HashMap();
    protected final PreferenceChangeListener preferenceChangeListener = this.buildPreferenceChangeListener();

    public PreferencesCollectionValueModel(Preferences preferences) {
        this(new ReadOnlyPropertyValueModel(preferences));
    }

    public PreferencesCollectionValueModel(ValueModel preferencesHolder) {
        super(preferencesHolder);
    }

    protected PreferenceChangeListener buildPreferenceChangeListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent e) {
                PreferencesCollectionValueModel.this.preferenceChanged(e.getKey(), e.getNewValue());
            }

            public String toString() {
                return "preference change listener";
            }
        };
    }

    @Override
    public synchronized Iterator iterator() {
        return this.preferences.values().iterator();
    }

    @Override
    public synchronized int size() {
        return this.preferences.size();
    }

    @Override
    protected Object value() {
        return this.iterator();
    }

    @Override
    protected Class<? extends ChangeListener> listenerClass() {
        return CollectionChangeListener.class;
    }

    @Override
    protected String listenerAspectName() {
        return "values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("values");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireCollectionChanged("values");
    }

    @Override
    protected void engageNonNullSubject() {
        ((Preferences)this.subject).addPreferenceChangeListener(this.preferenceChangeListener);
        Iterator stream = this.preferenceModels();
        while (stream.hasNext()) {
            PreferencePropertyValueModel preferenceModel = (PreferencePropertyValueModel)stream.next();
            this.preferences.put(preferenceModel.getKey(), preferenceModel);
        }
    }

    @Override
    protected void disengageNonNullSubject() {
        block2: {
            try {
                ((Preferences)this.subject).removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().equals("Node has been removed.")) break block2;
                throw ex;
            }
        }
        this.preferences.clear();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.subject);
    }

    protected Iterator preferenceModels() {
        String[] keys;
        try {
            keys = ((Preferences)this.subject).keys();
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException(ex);
        }
        return new TransformationIterator(new ArrayIterator<String>(keys)){

            protected Object transform(Object next) {
                return PreferencesCollectionValueModel.this.buildPreferenceModel((String)next);
            }
        };
    }

    protected PreferencePropertyValueModel buildPreferenceModel(String key) {
        return new PreferencePropertyValueModel(this.subjectHolder, key);
    }

    protected synchronized void preferenceChanged(String key, String newValue) {
        if (newValue == null) {
            PreferencePropertyValueModel preferenceModel = (PreferencePropertyValueModel)this.preferences.remove(key);
            this.fireItemRemoved("values", preferenceModel);
        } else if (!this.preferences.containsKey(key)) {
            PreferencePropertyValueModel preferenceModel = this.buildPreferenceModel(key);
            this.preferences.put(key, preferenceModel);
            this.fireItemAdded("values", preferenceModel);
        }
    }
}

