/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import javax.swing.ComboBoxModel;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ListModelAdapter;

public class ComboBoxModelAdapter
extends ListModelAdapter
implements ComboBoxModel {
    protected final PropertyValueModel selectionHolder;
    protected final PropertyChangeListener selectionListener;

    public ComboBoxModelAdapter(ListValueModel listHolder, PropertyValueModel selectionHolder) {
        super(listHolder);
        if (selectionHolder == null) {
            throw new NullPointerException();
        }
        this.selectionHolder = selectionHolder;
        this.selectionListener = this.buildSelectionListener();
    }

    public ComboBoxModelAdapter(CollectionValueModel collectionHolder, PropertyValueModel selectionHolder) {
        super(collectionHolder);
        if (selectionHolder == null) {
            throw new NullPointerException();
        }
        this.selectionHolder = selectionHolder;
        this.selectionListener = this.buildSelectionListener();
    }

    protected PropertyChangeListener buildSelectionListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                ComboBoxModelAdapter.this.fireSelectionChanged();
            }

            public String toString() {
                return "selection listener";
            }
        };
    }

    public Object getSelectedItem() {
        return this.selectionHolder.value();
    }

    public void setSelectedItem(Object selectedItem) {
        this.selectionHolder.setValue(selectedItem);
    }

    protected void engageModel() {
        super.engageModel();
        this.selectionHolder.addPropertyChangeListener("value", this.selectionListener);
    }

    protected void disengageModel() {
        this.selectionHolder.removePropertyChangeListener("value", this.selectionListener);
        super.disengageModel();
    }

    protected void fireSelectionChanged() {
        this.fireContentsChanged(this, -1, -1);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.selectionHolder + ":" + this.listHolder);
    }
}

