/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import java.util.Date;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeListener;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;

public class DateSpinnerModelAdapter
extends SpinnerDateModel {
    private final Date defaultValue;
    private final PropertyValueModel dateHolder;
    private final PropertyChangeListener dateChangeListener;

    public DateSpinnerModelAdapter(PropertyValueModel dateHolder) {
        this(dateHolder, new Date());
    }

    public DateSpinnerModelAdapter(PropertyValueModel dateHolder, Date defaultValue) {
        this(dateHolder, null, null, 5, defaultValue);
    }

    public DateSpinnerModelAdapter(PropertyValueModel dateHolder, Comparable start, Comparable end, int calendarField) {
        this(dateHolder, start, end, calendarField, new Date());
    }

    public DateSpinnerModelAdapter(PropertyValueModel dateHolder, Comparable start, Comparable end, int calendarField, Date defaultValue) {
        super(dateHolder.value() == null ? defaultValue : (Date)dateHolder.value(), start, end, calendarField);
        this.dateHolder = dateHolder;
        this.dateChangeListener = this.buildDateChangeListener();
        this.defaultValue = defaultValue;
    }

    private PropertyChangeListener buildDateChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                DateSpinnerModelAdapter.this.synchronize(e.newValue());
            }

            public String toString() {
                return "date listener";
            }
        };
    }

    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.dateHolder.value()));
        }
        return super.getValue();
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.dateHolder.setValue(value);
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.getChangeListeners().length == 0) {
            this.dateHolder.addPropertyChangeListener("value", this.dateChangeListener);
            this.synchronize(this.dateHolder.value());
        }
        super.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.getChangeListeners().length == 0) {
            this.dateHolder.removePropertyChangeListener("value", this.dateChangeListener);
        }
    }

    protected Date getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    void synchronize(Object value) {
        Object newValue = this.spinnerValueOf(value);
        if (!this.getValue().equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.dateHolder);
    }
}

