/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public class ListModelAdapter
extends AbstractListModel {
    protected ListValueModel listHolder;
    protected int listSize = 0;
    protected final ListChangeListener listChangeListener = this.buildListChangeListener();

    private ListModelAdapter() {
    }

    public ListModelAdapter(ListValueModel listHolder) {
        this();
        this.setModel(listHolder);
    }

    public ListModelAdapter(CollectionValueModel collectionHolder) {
        this();
        this.setModel(collectionHolder);
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ListModelAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ListModelAdapter.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ListModelAdapter.this.itemsReplaced(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                ListModelAdapter.this.itemsMoved(e);
            }

            public void listCleared(ListChangeEvent e) {
                ListModelAdapter.this.listCleared();
            }

            public void listChanged(ListChangeEvent e) {
                ListModelAdapter.this.listChanged();
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    public int getSize() {
        return this.listHolder.size();
    }

    public Object getElementAt(int index) {
        return this.listHolder.get(index);
    }

    public void addListDataListener(ListDataListener l) {
        if (this.hasNoListDataListeners()) {
            this.engageModel();
            this.listSize = this.listHolder.size();
        }
        super.addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        super.removeListDataListener(l);
        if (this.hasNoListDataListeners()) {
            this.disengageModel();
            this.listSize = 0;
        }
    }

    public ListValueModel getModel() {
        return this.listHolder;
    }

    public void setModel(ListValueModel listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        boolean hasListeners = this.hasListDataListeners();
        if (hasListeners) {
            this.disengageModel();
        }
        this.listHolder = listHolder;
        if (hasListeners) {
            this.engageModel();
            this.listChanged();
        }
    }

    public void setModel(CollectionValueModel collectionHolder) {
        this.setModel(new CollectionListValueModelAdapter(collectionHolder));
    }

    protected boolean hasNoListDataListeners() {
        return this.getListDataListeners().length == 0;
    }

    protected boolean hasListDataListeners() {
        return !this.hasNoListDataListeners();
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    protected void itemsAdded(ListChangeEvent e) {
        int start = e.index();
        int end = start + e.itemsSize() - 1;
        this.fireIntervalAdded(this, start, end);
        this.listSize += e.itemsSize();
    }

    protected void itemsRemoved(ListChangeEvent e) {
        int start = e.index();
        int end = start + e.itemsSize() - 1;
        this.fireIntervalRemoved(this, start, end);
        this.listSize -= e.itemsSize();
    }

    protected void itemsReplaced(ListChangeEvent e) {
        int start = e.index();
        int end = start + e.itemsSize() - 1;
        this.fireContentsChanged(this, start, end);
    }

    protected void itemsMoved(ListChangeEvent e) {
        int start = Math.min(e.sourceIndex(), e.targetIndex());
        int end = Math.max(e.sourceIndex(), e.targetIndex()) + e.moveLength() - 1;
        this.fireContentsChanged(this, start, end);
    }

    protected void listCleared() {
        if (this.listSize != 0) {
            this.fireIntervalRemoved(this, 0, this.listSize - 1);
            this.listSize = 0;
        }
    }

    protected void listChanged() {
        if (this.listSize != 0) {
            this.fireIntervalRemoved(this, 0, this.listSize - 1);
        }
        this.listSize = this.listHolder.size();
        if (this.listSize != 0) {
            this.fireIntervalAdded(this, 0, this.listSize - 1);
        } else {
            this.fireContentsChanged(this, 0, -1);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.listHolder);
    }
}

