/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;

public class NumberSpinnerModelAdapter
extends SpinnerNumberModel {
    private final Number defaultValue;
    private final PropertyValueModel numberHolder;
    private final PropertyChangeListener numberChangeListener;

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder) {
        this(numberHolder, 0);
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, int defaultValue) {
        this(numberHolder, null, null, new Integer(1), new Integer(defaultValue));
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, int minimum, int maximum, int stepSize) {
        this(numberHolder, minimum, maximum, stepSize, minimum);
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, int minimum, int maximum, int stepSize, int defaultValue) {
        this(numberHolder, new Integer(minimum), new Integer(maximum), new Integer(stepSize), new Integer(defaultValue));
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, double value, double minimum, double maximum, double stepSize) {
        this(numberHolder, value, minimum, maximum, stepSize, minimum);
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, double value, double minimum, double maximum, double stepSize, double defaultValue) {
        this(numberHolder, new Double(minimum), new Double(maximum), new Double(stepSize), new Double(defaultValue));
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, Comparable minimum, Comparable maximum, Number stepSize, Number defaultValue) {
        super(numberHolder.value() == null ? (Number)defaultValue : (Number)((Number)numberHolder.value()), minimum, maximum, stepSize);
        this.numberHolder = numberHolder;
        this.numberChangeListener = this.buildNumberChangeListener();
        this.defaultValue = defaultValue;
    }

    private PropertyChangeListener buildNumberChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                NumberSpinnerModelAdapter.this.synchronize(e.newValue());
            }

            public String toString() {
                return "number listener";
            }
        };
    }

    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.numberHolder.value()));
        }
        return super.getValue();
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.numberHolder.setValue(value);
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.addPropertyChangeListener("value", this.numberChangeListener);
            this.synchronize(this.numberHolder.value());
        }
        super.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.removePropertyChangeListener("value", this.numberChangeListener);
        }
    }

    protected Number getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    void synchronize(Object value) {
        Object newValue = this.spinnerValueOf(value);
        if (!this.getValue().equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.numberHolder);
    }
}

