/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;

public abstract class PrimitiveListTreeModel
extends DefaultTreeModel {
    private final ListValueModel listHolder;
    private final ListChangeListener listChangeListener;

    public PrimitiveListTreeModel(ListValueModel listHolder) {
        super(new DefaultMutableTreeNode(null, true));
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.listChangeListener = new PrimitiveListChangeListener();
    }

    protected abstract void primitiveChanged(int var1, Object var2);

    public void valueForPathChanged(TreePath path, Object newValue) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        int index = ((TreeNode)this.getRoot()).getIndex(node);
        this.primitiveChanged(index, newValue);
    }

    public void addTreeModelListener(TreeModelListener l) {
        if (this.getTreeModelListeners().length == 0) {
            this.listHolder.addListChangeListener("list values", this.listChangeListener);
            this.synchronizeList();
        }
        super.addTreeModelListener(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        super.removeTreeModelListener(l);
        if (this.getTreeModelListeners().length == 0) {
            this.listHolder.removeListChangeListener("list values", this.listChangeListener);
        }
    }

    void synchronizeList() {
        this.clearList();
        this.buildList();
    }

    void clearList() {
        int childcount = this.root.getChildCount();
        int i = childcount - 1;
        while (i >= 0) {
            this.removeNodeFromParent((MutableTreeNode)this.root.getChildAt(i));
            --i;
        }
    }

    private void buildList() {
        Iterator stream = this.listHolder.iterator();
        while (stream.hasNext()) {
            this.addPrimitive(stream.next());
        }
    }

    private void addPrimitive(Object primitive) {
        this.insertPrimitive(this.root.getChildCount(), primitive);
    }

    void insertPrimitive(int index, Object primitive) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(primitive, false);
        this.insertNodeInto(node, (MutableTreeNode)this.root, index);
    }

    MutableTreeNode removeNode(int index) {
        MutableTreeNode node = (MutableTreeNode)this.root.getChildAt(index);
        this.removeNodeFromParent(node);
        return node;
    }

    void replacePrimitive(int index, Object primitive) {
        MutableTreeNode node = (MutableTreeNode)this.root.getChildAt(index);
        node.setUserObject(primitive);
        this.nodeChanged(node);
    }

    private class PrimitiveListChangeListener
    implements ListChangeListener {
        PrimitiveListChangeListener() {
        }

        public void itemsAdded(ListChangeEvent e) {
            int i = e.index();
            ListIterator<?> stream = e.items();
            while (stream.hasNext()) {
                PrimitiveListTreeModel.this.insertPrimitive(i++, stream.next());
            }
        }

        public void itemsRemoved(ListChangeEvent e) {
            int i = 0;
            while (i < e.itemsSize()) {
                PrimitiveListTreeModel.this.removeNode(e.index());
                ++i;
            }
        }

        public void itemsReplaced(ListChangeEvent e) {
            int i = e.index();
            ListIterator<?> stream = e.items();
            while (stream.hasNext()) {
                PrimitiveListTreeModel.this.replacePrimitive(i++, stream.next());
            }
        }

        public void itemsMoved(ListChangeEvent e) {
            ArrayList<MutableTreeNode> temp = new ArrayList<MutableTreeNode>(e.moveLength());
            int i = 0;
            while (i < e.moveLength()) {
                temp.add(PrimitiveListTreeModel.this.removeNode(e.sourceIndex()));
                ++i;
            }
            i = e.targetIndex();
            for (MutableTreeNode node : temp) {
                PrimitiveListTreeModel.this.insertPrimitive(i++, node);
            }
        }

        public void listCleared(ListChangeEvent e) {
            PrimitiveListTreeModel.this.clearList();
        }

        public void listChanged(ListChangeEvent e) {
            PrimitiveListTreeModel.this.synchronizeList();
        }
    }
}

