/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import org.eclipse.jpt.utility.internal.BidiFilter;
import org.eclipse.jpt.utility.internal.BidiTransformer;
import org.eclipse.jpt.utility.internal.model.value.FilteringPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ToggleButtonModelAdapter;

public class RadioButtonModelAdapter
extends ToggleButtonModelAdapter {
    public RadioButtonModelAdapter(PropertyValueModel valueHolder, Object buttonValue, boolean defaultValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue), defaultValue);
    }

    public RadioButtonModelAdapter(PropertyValueModel valueHolder, Object buttonValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue));
    }

    public static PropertyValueModel buildBooleanHolder(PropertyValueModel valueHolder, Object buttonValue) {
        FilteringPropertyValueModel filteringPVM = new FilteringPropertyValueModel(valueHolder, new RadioButtonFilter(buttonValue));
        return new TransformationPropertyValueModel(filteringPVM, new RadioButtonTransformer(buttonValue));
    }

    public void setSelected(boolean b) {
        if (!b && this.isArmed()) {
            return;
        }
        super.setSelected(b);
    }

    public static class RadioButtonFilter
    implements BidiFilter {
        private Object buttonValue;

        public RadioButtonFilter(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        public boolean accept(Object value) {
            return true;
        }

        public boolean reverseAccept(Object value) {
            return value == this.buttonValue;
        }
    }

    public static class RadioButtonTransformer
    implements BidiTransformer {
        private Object buttonValue;

        public RadioButtonTransformer(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        public Object transform(Object value) {
            return value == null ? null : Boolean.valueOf(value == this.buttonValue);
        }

        public Object reverseTransform(Object value) {
            return (Boolean)value != false ? this.buttonValue : null;
        }
    }
}

