/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import javax.swing.AbstractSpinnerModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;

public class SpinnerModelAdapter
extends AbstractSpinnerModel {
    protected final SpinnerModel delegate;
    protected final ChangeListener delegateListener;
    protected final PropertyValueModel valueHolder;
    protected final PropertyChangeListener valueListener;

    public SpinnerModelAdapter(PropertyValueModel valueHolder, SpinnerModel delegate) {
        if (valueHolder == null || delegate == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.delegate = delegate;
        this.valueListener = this.buildValueListener();
        this.delegateListener = this.buildDelegateListener();
    }

    public SpinnerModelAdapter(PropertyValueModel valueHolder) {
        this(valueHolder, new SpinnerNumberModel());
    }

    protected PropertyChangeListener buildValueListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                SpinnerModelAdapter.this.valueChanged(e);
            }

            public String toString() {
                return "value listener";
            }
        };
    }

    protected void fireStateChanged() {
        super.fireStateChanged();
    }

    protected ChangeListener buildDelegateListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SpinnerModelAdapter.this.fireStateChanged();
            }

            public String toString() {
                return "delegate listener";
            }
        };
    }

    public Object getValue() {
        return this.delegate.getValue();
    }

    public void setValue(Object value) {
        this.delegate.setValue(value);
        this.valueHolder.setValue(value);
    }

    public Object getNextValue() {
        return this.delegate.getNextValue();
    }

    public Object getPreviousValue() {
        return this.delegate.getPreviousValue();
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList.getListenerCount(ChangeListener.class) == 0) {
            this.delegate.addChangeListener(this.delegateListener);
            this.engageValueHolder();
        }
        super.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.listenerList.getListenerCount(ChangeListener.class) == 0) {
            this.disengageValueHolder();
            this.delegate.removeChangeListener(this.delegateListener);
        }
    }

    protected void valueChanged(PropertyChangeEvent e) {
        this.synchronizeDelegate(e.newValue());
    }

    protected void synchronizeDelegate(Object value) {
        if (!this.delegate.getValue().equals(value)) {
            this.delegate.setValue(value);
        }
    }

    protected void engageValueHolder() {
        this.valueHolder.addPropertyChangeListener("value", this.valueListener);
        this.synchronizeDelegate(this.valueHolder.value());
    }

    protected void disengageValueHolder() {
        this.valueHolder.removePropertyChangeListener("value", this.valueListener);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.valueHolder);
    }
}

