/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ColumnAdapter;

public class TableModelAdapter
extends AbstractTableModel {
    private ListValueModel listHolder;
    private final ListChangeListener listChangeListener;
    private final ArrayList<PropertyValueModel[]> rows;
    private final ColumnAdapter columnAdapter;
    private final PropertyChangeListener cellListener;

    public TableModelAdapter(ListValueModel listHolder, ColumnAdapter columnAdapter) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.columnAdapter = columnAdapter;
        this.listChangeListener = this.buildListChangeListener();
        this.rows = new ArrayList();
        this.cellListener = this.buildCellListener();
    }

    public TableModelAdapter(CollectionValueModel collectionHolder, ColumnAdapter columnAdapter) {
        this(new CollectionListValueModelAdapter(collectionHolder), columnAdapter);
    }

    private ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                TableModelAdapter.this.addRows(e.index(), e.itemsSize(), e.items());
            }

            public void itemsRemoved(ListChangeEvent e) {
                TableModelAdapter.this.removeRows(e.index(), e.itemsSize());
            }

            public void itemsReplaced(ListChangeEvent e) {
                TableModelAdapter.this.replaceRows(e.index(), e.items());
            }

            public void itemsMoved(ListChangeEvent e) {
                TableModelAdapter.this.moveRows(e.targetIndex(), e.sourceIndex(), e.moveLength());
            }

            public void listCleared(ListChangeEvent e) {
                TableModelAdapter.this.clearTable();
            }

            public void listChanged(ListChangeEvent e) {
                TableModelAdapter.this.rebuildTable();
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    private PropertyChangeListener buildCellListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent evt) {
                TableModelAdapter.this.cellChanged((PropertyValueModel)evt.getSource());
            }

            public String toString() {
                return "cell listener";
            }
        };
    }

    public int getColumnCount() {
        return this.columnAdapter.getColumnCount();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public String getColumnName(int column) {
        return this.columnAdapter.getColumnName(column);
    }

    public Class getColumnClass(int columnIndex) {
        return this.columnAdapter.getColumnClass(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columnAdapter.isColumnEditable(columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        PropertyValueModel[] row = this.rows.get(rowIndex);
        return row[columnIndex].value();
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        PropertyValueModel[] row = this.rows.get(rowIndex);
        row[columnIndex].setValue(value);
    }

    public void addTableModelListener(TableModelListener l) {
        if (this.hasNoTableModelListeners()) {
            this.engageModel();
        }
        super.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
        if (this.hasNoTableModelListeners()) {
            this.disengageModel();
        }
    }

    public ListValueModel getModel() {
        return this.listHolder;
    }

    public void setModel(ListValueModel listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        boolean hasListeners = this.hasTableModelListeners();
        if (hasListeners) {
            this.disengageModel();
        }
        this.listHolder = listHolder;
        if (hasListeners) {
            this.engageModel();
            this.fireTableDataChanged();
        }
    }

    public void setModel(CollectionValueModel collectionHolder) {
        this.setModel(new CollectionListValueModelAdapter(collectionHolder));
    }

    protected boolean hasNoTableModelListeners() {
        return this.listenerList.getListenerCount(TableModelListener.class) == 0;
    }

    protected boolean hasTableModelListeners() {
        return !this.hasNoTableModelListeners();
    }

    private void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
        this.engageAllCells();
    }

    private void engageAllCells() {
        this.rows.ensureCapacity(this.listHolder.size());
        Iterator stream = this.listHolder.iterator();
        while (stream.hasNext()) {
            PropertyValueModel[] row = this.columnAdapter.cellModels(stream.next());
            this.engageRow(row);
            this.rows.add(row);
        }
    }

    private void engageRow(PropertyValueModel[] row) {
        int i = row.length;
        while (i-- > 0) {
            row[i].addPropertyChangeListener("value", this.cellListener);
        }
    }

    private void disengageModel() {
        this.disengageAllCells();
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    private void disengageAllCells() {
        for (PropertyValueModel[] row : this.rows) {
            this.disengageRow(row);
        }
        this.rows.clear();
    }

    private void disengageRow(PropertyValueModel[] row) {
        int i = row.length;
        while (i-- > 0) {
            row[i].removePropertyChangeListener("value", this.cellListener);
        }
    }

    void cellChanged(PropertyValueModel cellHolder) {
        int i = this.rows.size();
        while (i-- > 0) {
            PropertyValueModel[] row = this.rows.get(i);
            int j = row.length;
            while (j-- > 0) {
                if (row[j] != cellHolder) continue;
                this.fireTableCellUpdated(i, j);
            }
        }
    }

    void addRows(int index, int size, Iterator items) {
        ArrayList<PropertyValueModel[]> newRows = new ArrayList<PropertyValueModel[]>(size);
        while (items.hasNext()) {
            PropertyValueModel[] row = this.columnAdapter.cellModels(items.next());
            this.engageRow(row);
            newRows.add(row);
        }
        this.rows.addAll(index, newRows);
        this.fireTableRowsInserted(index, index + size - 1);
    }

    void removeRows(int index, int size) {
        int i = 0;
        while (i < size) {
            this.disengageRow(this.rows.remove(index));
            ++i;
        }
        this.fireTableRowsDeleted(index, index + size - 1);
    }

    void replaceRows(int index, Iterator items) {
        int i = index;
        while (items.hasNext()) {
            PropertyValueModel[] row = this.rows.get(i);
            this.disengageRow(row);
            row = this.columnAdapter.cellModels(items.next());
            this.engageRow(row);
            this.rows.set(i, row);
            ++i;
        }
        this.fireTableRowsUpdated(index, i - 1);
    }

    void moveRows(int targetIndex, int sourceIndex, int length) {
        ArrayList<PropertyValueModel[]> temp = new ArrayList<PropertyValueModel[]>(length);
        int i = 0;
        while (i < length) {
            temp.add(this.rows.remove(sourceIndex));
            ++i;
        }
        this.rows.addAll(targetIndex, temp);
        int start = Math.min(targetIndex, sourceIndex);
        int end = Math.max(targetIndex, sourceIndex) + length - 1;
        this.fireTableRowsUpdated(start, end);
    }

    void clearTable() {
        this.disengageAllCells();
        this.fireTableDataChanged();
    }

    void rebuildTable() {
        this.disengageAllCells();
        this.engageAllCells();
        this.fireTableDataChanged();
    }
}

