/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;

public class ToggleButtonModelAdapter
extends JToggleButton.ToggleButtonModel {
    protected final boolean defaultValue;
    protected final PropertyValueModel booleanHolder;
    protected final PropertyChangeListener booleanChangeListener;

    public ToggleButtonModelAdapter(PropertyValueModel booleanHolder, boolean defaultValue) {
        if (booleanHolder == null) {
            throw new NullPointerException();
        }
        this.booleanHolder = booleanHolder;
        this.booleanChangeListener = this.buildBooleanChangeListener();
        this.defaultValue = defaultValue;
    }

    public ToggleButtonModelAdapter(PropertyValueModel booleanHolder) {
        this(booleanHolder, false);
    }

    protected PropertyChangeListener buildBooleanChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                ToggleButtonModelAdapter.this.booleanChanged(e);
            }

            public String toString() {
                return "boolean listener";
            }
        };
    }

    public void setSelected(boolean b) {
        if (this.isSelected() != b) {
            super.setSelected(b);
            this.booleanHolder.setValue(b);
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        super.removeActionListener(l);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void addItemListener(ItemListener l) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        super.removeItemListener(l);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        super.removeChangeListener(l);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasNoListeners() {
        return this.listenerList.getListenerCount() == 0;
    }

    protected boolean getDefaultValue() {
        return this.defaultValue;
    }

    protected void setSelected(Boolean value) {
        if (value == null) {
            this.setSelected(this.getDefaultValue());
        } else {
            this.setSelected((boolean)value);
        }
    }

    protected void booleanChanged(PropertyChangeEvent e) {
        this.setSelected((Boolean)e.newValue());
    }

    protected void engageModel() {
        this.booleanHolder.addPropertyChangeListener("value", this.booleanChangeListener);
        this.setSelected((Boolean)this.booleanHolder.value());
    }

    protected void disengageModel() {
        this.booleanHolder.removePropertyChangeListener("value", this.booleanChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.booleanHolder);
    }
}

