/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.internal.model.value.ListValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TreeNodeValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.AbstractTreeModel;

public class TreeModelAdapter
extends AbstractTreeModel {
    private final PropertyValueModel rootHolder;
    private final PropertyChangeListener rootListener;
    private final StateChangeListener nodeStateListener;
    private final PropertyChangeListener nodeValueListener;
    private final ListChangeListener childrenListener;
    private TreeNodeValueModel root;
    final IdentityHashMap<TreeNodeValueModel, List<TreeNodeValueModel>> childrenLists;
    final IdentityHashMap<ListValueModel, TreeNodeValueModel> parents;

    public TreeModelAdapter(PropertyValueModel rootHolder) {
        if (rootHolder == null) {
            throw new NullPointerException();
        }
        this.rootHolder = rootHolder;
        this.rootListener = this.buildRootListener();
        this.nodeStateListener = this.buildNodeStateListener();
        this.nodeValueListener = this.buildNodeValueListener();
        this.childrenListener = this.buildChildrenListener();
        this.childrenLists = new IdentityHashMap();
        this.parents = new IdentityHashMap();
    }

    public TreeModelAdapter(TreeNodeValueModel root) {
        this(new ReadOnlyPropertyValueModel(root));
    }

    private PropertyChangeListener buildRootListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                TreeModelAdapter.this.rootChanged();
            }

            public String toString() {
                return "root listener";
            }
        };
    }

    private PropertyChangeListener buildNodeValueListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                TreeModelAdapter.this.nodeChanged((TreeNodeValueModel)e.getSource());
            }

            public String toString() {
                return "node value listener";
            }
        };
    }

    private StateChangeListener buildNodeStateListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent e) {
                TreeModelAdapter.this.nodeChanged((TreeNodeValueModel)e.getSource());
            }

            public String toString() {
                return "node state listener";
            }
        };
    }

    private ListChangeListener buildChildrenListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                new EventChangePolicy(e).addChildren();
            }

            public void itemsRemoved(ListChangeEvent e) {
                new EventChangePolicy(e).removeChildren();
            }

            public void itemsReplaced(ListChangeEvent e) {
                new EventChangePolicy(e).replaceChildren();
            }

            public void itemsMoved(ListChangeEvent e) {
                new EventChangePolicy(e).moveChildren();
            }

            public void listCleared(ListChangeEvent e) {
                new EventChangePolicy(e).clearChildren();
            }

            public void listChanged(ListChangeEvent e) {
                new EventChangePolicy(e).rebuildChildren();
            }

            public String toString() {
                return "children listener";
            }
        };
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNodeValueModel)parent).child(index);
    }

    public int getChildCount(Object parent) {
        return ((TreeNodeValueModel)parent).childrenSize();
    }

    public boolean isLeaf(Object node) {
        return ((TreeNodeValueModel)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        ((TreeNodeValueModel)path.getLastPathComponent()).setValue(newValue);
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNodeValueModel)parent).indexOfChild((TreeNodeValueModel)child);
    }

    public void addTreeModelListener(TreeModelListener l) {
        if (this.hasNoTreeModelListeners()) {
            this.engageModel();
        }
        super.addTreeModelListener(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        super.removeTreeModelListener(l);
        if (this.hasNoTreeModelListeners()) {
            this.disengageModel();
        }
    }

    private void engageModel() {
        this.rootHolder.addPropertyChangeListener("value", this.rootListener);
        this.root = (TreeNodeValueModel)this.rootHolder.value();
        if (this.root == null) {
            throw new NullPointerException();
        }
        this.engageNode(this.root);
        this.addRoot();
    }

    private void addRoot() {
        this.addNode(0, this.root);
    }

    private void disengageModel() {
        this.removeRoot();
        this.disengageNode(this.root);
        this.root = null;
        this.rootHolder.removePropertyChangeListener("value", this.rootListener);
    }

    private void removeRoot() {
        this.removeNode(0, this.root);
    }

    void rootChanged() {
        TreeNodeValueModel newRoot = (TreeNodeValueModel)this.rootHolder.value();
        if (newRoot == null) {
            throw new NullPointerException();
        }
        this.removeRoot();
        TreeNodeValueModel oldRoot = this.root;
        this.root = newRoot;
        this.engageNode(this.root);
        this.fireTreeRootReplaced(this.root);
        this.disengageNode(oldRoot);
        this.addRoot();
    }

    void nodeChanged(TreeNodeValueModel node) {
        TreeNodeValueModel parent = node.parent();
        if (parent == null) {
            this.fireTreeRootChanged(node);
        } else {
            this.fireTreeNodeChanged(parent.path(), parent.indexOfChild(node), node);
        }
    }

    void addChildren(Object[] path, int[] childIndices, Object[] children) {
        int len = childIndices.length;
        int i = 0;
        while (i < len) {
            this.engageNode((TreeNodeValueModel)children[i]);
            ++i;
        }
        this.fireTreeNodesInserted(path, childIndices, children);
        i = 0;
        while (i < len) {
            this.addNode(childIndices[i], (TreeNodeValueModel)children[i]);
            ++i;
        }
    }

    private void engageNode(TreeNodeValueModel node) {
        node.addStateChangeListener(this.nodeStateListener);
        node.addPropertyChangeListener("value", this.nodeValueListener);
        node.childrenModel().addListChangeListener("list values", this.childrenListener);
    }

    private void addNode(int index, TreeNodeValueModel node) {
        this.addNodeToInternalTree(node.parent(), index, node, node.childrenModel());
        new NodeChangePolicy(node).addChildren();
    }

    private void addNodeToInternalTree(TreeNodeValueModel parent, int index, TreeNodeValueModel node, ListValueModel childrenModel) {
        List<TreeNodeValueModel> siblings = this.childrenLists.get(parent);
        if (siblings == null) {
            siblings = new ArrayList<TreeNodeValueModel>();
            this.childrenLists.put(parent, siblings);
        }
        siblings.add(index, node);
        this.parents.put(childrenModel, node);
    }

    void removeChildren(Object[] path, int[] childIndices, Object[] children) {
        int len = childIndices.length;
        int i = 0;
        while (i < len) {
            this.removeNode(childIndices[i] - i, (TreeNodeValueModel)children[i]);
            ++i;
        }
        this.fireTreeNodesRemoved(path, childIndices, children);
        i = 0;
        while (i < len) {
            this.disengageNode((TreeNodeValueModel)children[i]);
            ++i;
        }
    }

    private void removeNode(int index, TreeNodeValueModel node) {
        new NodeChangePolicy(node).removeChildren();
        this.removeNodeFromInternalTree(node.parent(), index, node, node.childrenModel());
    }

    private void removeNodeFromInternalTree(TreeNodeValueModel parent, int index, TreeNodeValueModel node, ListValueModel childrenModel) {
        this.parents.remove(childrenModel);
        List<TreeNodeValueModel> siblings = this.childrenLists.get(parent);
        siblings.remove(index);
        if (siblings.isEmpty()) {
            this.childrenLists.remove(parent);
        }
    }

    private void disengageNode(TreeNodeValueModel node) {
        node.childrenModel().removeListChangeListener("list values", this.childrenListener);
        node.removePropertyChangeListener("value", this.nodeValueListener);
        node.removeStateChangeListener(this.nodeStateListener);
    }

    void moveChildren(TreeNodeValueModel parent, int targetIndex, int sourceIndex, int length) {
        List<TreeNodeValueModel> childrenList = this.childrenLists.get(parent);
        ArrayList<TreeNodeValueModel> temp = new ArrayList<TreeNodeValueModel>(length);
        int i = 0;
        while (i < length) {
            temp.add(childrenList.remove(sourceIndex));
            ++i;
        }
        childrenList.addAll(targetIndex, temp);
        this.fireTreeStructureChanged(parent.path());
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.root);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ChangePolicy {
        ChangePolicy() {
        }

        void addChildren() {
            TreeModelAdapter.this.addChildren(this.parent().path(), this.childIndices(), this.childArray());
        }

        void removeChildren() {
            TreeModelAdapter.this.removeChildren(this.parent().path(), this.childIndices(), this.childArray());
        }

        int[] childIndices() {
            return this.buildIndices(this.childrenStartIndex(), this.childrenSize());
        }

        Object[] childArray() {
            return this.buildArray(this.children(), this.childrenSize());
        }

        Object[] buildArray(Iterator<?> stream, int size) {
            Object[] array = new Object[size];
            int i = 0;
            while (stream.hasNext()) {
                array[i] = stream.next();
                ++i;
            }
            return array;
        }

        int[] buildIndices(int size) {
            return this.buildIndices(0, size);
        }

        int[] buildIndices(int start, int size) {
            int[] indices = new int[size];
            int index = start;
            int i = 0;
            while (i < size) {
                indices[i] = index++;
                ++i;
            }
            return indices;
        }

        abstract TreeNodeValueModel parent();

        abstract int childrenStartIndex();

        abstract int childrenSize();

        abstract Iterator children();
    }

    private class EventChangePolicy
    extends ChangePolicy {
        private ListChangeEvent event;

        EventChangePolicy(ListChangeEvent event) {
            this.event = event;
        }

        TreeNodeValueModel parent() {
            return TreeModelAdapter.this.parents.get(this.event.getSource());
        }

        int childrenStartIndex() {
            return this.event.index();
        }

        int childrenSize() {
            return this.event.itemsSize();
        }

        Iterator children() {
            return this.event.items();
        }

        void replaceChildren() {
            Object[] parentPath = this.parent().path();
            int[] childIndices = this.childIndices();
            TreeModelAdapter.this.removeChildren(parentPath, childIndices, this.replacedChildren());
            TreeModelAdapter.this.addChildren(parentPath, childIndices, this.childArray());
        }

        void moveChildren() {
            TreeModelAdapter.this.moveChildren(this.parent(), this.event.targetIndex(), this.event.sourceIndex(), this.event.moveLength());
        }

        void clearChildren() {
            TreeNodeValueModel parent = this.parent();
            Object[] parentPath = parent.path();
            List<TreeNodeValueModel> childrenList = TreeModelAdapter.this.childrenLists.get(parent);
            int[] childIndices = this.buildIndices(childrenList.size());
            Object[] childArray = this.buildArray(childrenList.iterator(), childrenList.size());
            TreeModelAdapter.this.removeChildren(parentPath, childIndices, childArray);
        }

        void rebuildChildren() {
            TreeNodeValueModel parent = this.parent();
            Object[] parentPath = parent.path();
            List<TreeNodeValueModel> childrenList = TreeModelAdapter.this.childrenLists.get(parent);
            int[] childIndices = this.buildIndices(childrenList.size());
            Object[] childArray = this.buildArray(childrenList.iterator(), childrenList.size());
            TreeModelAdapter.this.removeChildren(parentPath, childIndices, childArray);
            childIndices = this.buildIndices(parent.childrenModel().size());
            childArray = this.buildArray(parent.childrenModel().iterator(), parent.childrenSize());
            TreeModelAdapter.this.addChildren(parentPath, childIndices, childArray);
        }

        Object[] replacedChildren() {
            return this.buildArray(this.event.replacedItems(), this.event.itemsSize());
        }
    }

    private class NodeChangePolicy
    extends ChangePolicy {
        private TreeNodeValueModel node;

        NodeChangePolicy(TreeNodeValueModel node) {
            this.node = node;
        }

        TreeNodeValueModel parent() {
            return this.node;
        }

        int childrenStartIndex() {
            return 0;
        }

        int childrenSize() {
            return this.node.childrenModel().size();
        }

        Iterator children() {
            return this.node.childrenModel().iterator();
        }
    }
}

