/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.RubberbandDragTracker;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.RubberbandSelectionTool;
import org.eclipse.gmf.runtime.diagram.ui.util.SelectInDiagramHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;

public class RubberbandDragTrackerForBPMN
extends RubberbandDragTracker {
    private static Field selectedEditPartsField;
    private static Field modeField;
    private static Method eraseTargetFeedbackMethod;
    private static Method showMarqueeFeedbackMethod;
    private static Method showTargetFeedbackMethod;
    private static Method getAllChildrenMethod;
    private static Method getMarqueeBoundsMethod;
    private static Method isFigureVisibleNotPrivateMethod;
    private static final Object[] empty;
    private static final Request MARQUEE_REQUEST_NOT_PRIVATE;
    private static final int TOGGLE_MODE_NOT_PRIVATE = 1;
    private static final int APPEND_MODE_NOT_PRIVATE = 2;

    static {
        empty = new Object[0];
        MARQUEE_REQUEST_NOT_PRIVATE = new Request((Object)"selection");
    }

    private static final void init() {
        if (modeField != null) {
            return;
        }
        Class[] empty = new Class[]{};
        try {
            modeField = RubberbandSelectionTool.class.getDeclaredField("mode");
            modeField.setAccessible(true);
            selectedEditPartsField = RubberbandSelectionTool.class.getDeclaredField("selectedEditParts");
            selectedEditPartsField.setAccessible(true);
            eraseTargetFeedbackMethod = RubberbandSelectionTool.class.getDeclaredMethod("eraseTargetFeedback", empty);
            eraseTargetFeedbackMethod.setAccessible(true);
            getAllChildrenMethod = RubberbandSelectionTool.class.getDeclaredMethod("getAllChildren", empty);
            getAllChildrenMethod.setAccessible(true);
            getMarqueeBoundsMethod = RubberbandSelectionTool.class.getDeclaredMethod("getMarqueeBounds", empty);
            getMarqueeBoundsMethod.setAccessible(true);
            showMarqueeFeedbackMethod = RubberbandSelectionTool.class.getDeclaredMethod("showMarqueeFeedback", empty);
            showMarqueeFeedbackMethod.setAccessible(true);
            showTargetFeedbackMethod = RubberbandSelectionTool.class.getDeclaredMethod("showTargetFeedback", empty);
            showTargetFeedbackMethod.setAccessible(true);
            Class[] param = new Class[]{IFigure.class};
            isFigureVisibleNotPrivateMethod = RubberbandSelectionTool.class.getDeclaredMethod("isFigureVisible", param);
            isFigureVisibleNotPrivateMethod.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public RubberbandDragTrackerForBPMN() {
        RubberbandDragTrackerForBPMN.init();
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedbackNotPrivate();
            this.eraseTargetFeedbackNotPrivate();
            this.setSelectedEditParts(this.calculateNewSelectionNotPrivate());
            this.showTargetFeedbackNotPrivate();
            SelectInDiagramHelper.exposeLocation((FigureCanvas)((FigureCanvas)this.getCurrentViewer().getControl()), (Point)this.getLocation());
        }
        return true;
    }

    protected void showMarqueeFeedbackNotPrivate() {
        try {
            showMarqueeFeedbackMethod.invoke((Object)this, empty);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected void eraseTargetFeedbackNotPrivate() {
        try {
            eraseTargetFeedbackMethod.invoke((Object)this, empty);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected void showTargetFeedbackNotPrivate() {
        try {
            showTargetFeedbackMethod.invoke((Object)this, empty);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected void setSelectedEditParts(List selectedEPs) {
        try {
            selectedEditPartsField.set((Object)this, selectedEPs);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected List calculateNewSelectionNotPrivate() {
        ArrayList<EditPart> newSelections = new ArrayList<EditPart>();
        for (EditPart child : this.getAllChildrenNotPrivate()) {
            IFigure figure;
            if (!child.isSelectable() || (figure = this.getFigureToUseToCalculateSelection((GraphicalEditPart)child)) == null) continue;
            Rectangle r = this.getRectangleToUseToCalculateSelection((GraphicalEditPart)child, figure);
            figure.translateToAbsolute((Translatable)r);
            Rectangle marqueeBounds = this.getMarqueeBoundsNotPrivate();
            this.getMarqueeFeedbackFigure().translateToRelative((Translatable)r);
            if (!marqueeBounds.contains(r.getTopLeft()) || !marqueeBounds.contains(r.getBottomRight()) || child.getTargetEditPart(MARQUEE_REQUEST_NOT_PRIVATE) != child || !this.isFigureVisibleNotPrivate(figure)) continue;
            newSelections.add(child);
        }
        return newSelections;
    }

    protected IFigure getFigureToUseToCalculateSelection(GraphicalEditPart graphicalEditPart) {
        return graphicalEditPart.getFigure();
    }

    protected Rectangle getRectangleToUseToCalculateSelection(GraphicalEditPart graphicalEditPart, IFigure epFigure) {
        Rectangle res = epFigure.getBounds().getCopy();
        if (graphicalEditPart instanceof SubProcessEditPart) {
            res.height -= 35;
        }
        return res;
    }

    protected boolean isFigureVisibleNotPrivate(IFigure figure) {
        Object[] param = new Object[]{figure};
        try {
            return (Boolean)isFigureVisibleNotPrivateMethod.invoke((Object)this, param);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected Rectangle getMarqueeBoundsNotPrivate() {
        try {
            return (Rectangle)getMarqueeBoundsMethod.invoke((Object)this, empty);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected int getSelectionModeNotPrivate() {
        try {
            return modeField.getInt((Object)this);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 1;
    }

    protected HashSet getAllChildrenNotPrivate() {
        try {
            return (HashSet)getAllChildrenMethod.invoke((Object)this, empty);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        List newSelections = this.calculateNewSelectionNotPrivate();
        if (this.getSelectionModeNotPrivate() == 2) {
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                viewer.appendSelection(editPart);
                ++i;
            }
        } else if (this.getSelectionModeNotPrivate() == 1) {
            ArrayList<EditPart> selected = new ArrayList<EditPart>(viewer.getSelectedEditParts());
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                if (editPart.getSelected() != 0) {
                    selected.remove(editPart);
                } else {
                    selected.add(editPart);
                }
                ++i;
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(newSelections));
        }
    }
}

