/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.service.internal.policy;

import java.util.List;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IPolicyStateEnum;
import org.eclipse.wst.ws.service.policy.IStateEnumerationItem;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;

public class EnumerationStateImpl
implements IPolicyStateEnum {
    private final String VALUE = "default.value.key";
    private String enumId;
    private List<IStateEnumerationItem> enumList;
    private IPolicyState state;
    private String defaultId;

    public EnumerationStateImpl(String enumId, String defaultId, IPolicyState state) {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        this.enumId = enumId;
        this.enumList = platform.getStateEnumeration(enumId);
        this.state = state;
        this.defaultId = this.enumList.get(0).getId();
        if (defaultId != null) {
            this.defaultId = defaultId;
            state.putDefaultValue("default.value.key", defaultId, false);
        } else {
            for (IStateEnumerationItem enumItem : this.enumList) {
                if (!enumItem.isDefault()) continue;
                this.defaultId = enumItem.getId();
                state.putDefaultValue("default.value.key", this.defaultId, false);
                break;
            }
        }
    }

    public String getEnumId() {
        return this.enumId;
    }

    public String getDefaultId() {
        return this.defaultId;
    }

    public void setCurrentItem(String itemId) {
        for (IStateEnumerationItem enumItem : this.enumList) {
            String enumItemId = enumItem.getId();
            if (!enumItemId.equals(itemId)) continue;
            this.state.putValue("default.value.key", enumItemId);
            break;
        }
    }

    public IStateEnumerationItem getCurrentItem() {
        String currentEnum = this.state.getValue("default.value.key");
        IStateEnumerationItem currentItem = null;
        for (IStateEnumerationItem enumItem : this.enumList) {
            if (!enumItem.getId().equals(currentEnum)) continue;
            currentItem = enumItem;
            break;
        }
        return currentItem;
    }
}

