/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.service.internal.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.ws.service.internal.policy.LocalUtils;
import org.eclipse.wst.ws.service.internal.policy.PolicyStateImpl;
import org.eclipse.wst.ws.service.internal.policy.ServicePolicyImpl;
import org.eclipse.wst.ws.service.internal.policy.ServicePolicyRegistry;
import org.eclipse.wst.ws.service.internal.policy.StateEnumerationItemImpl;
import org.eclipse.wst.ws.service.policy.IFilter;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.IStateEnumerationItem;
import org.eclipse.wst.ws.service.policy.ServicePolicyActivator;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyChildChangeListener;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyPlatformLoadListener;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePolicyPlatformImpl {
    private List<IPolicyPlatformLoadListener> loadListeners;
    private Map<String, ServicePolicyImpl> committedPolicyMap;
    private Map<String, ServicePolicyImpl> policyMap;
    private Map<String, List<IStateEnumerationItem>> enumList;
    private Map<String, StateEnumerationItemImpl> enumItemList;
    private Map<IProject, ProjectEntry> enabledProjectMap;
    private List<Expression> enabledList;
    private List<IPolicyChildChangeListener> childChangeListeners;
    private List<IServicePolicy> queuedChildChangePolicy;
    private List<Boolean> queuedChildChangeAdded;

    public void load() {
        ServicePolicyRegistry registry = new ServicePolicyRegistry(this);
        List<String> localIds = LocalUtils.getLocalPolicyIds();
        this.loadListeners = new Vector<IPolicyPlatformLoadListener>();
        this.policyMap = new HashMap<String, ServicePolicyImpl>();
        this.enumList = new HashMap<String, List<IStateEnumerationItem>>();
        this.enumItemList = new HashMap<String, StateEnumerationItemImpl>();
        this.enabledProjectMap = new HashMap<IProject, ProjectEntry>();
        this.enabledList = new Vector<Expression>();
        this.childChangeListeners = new Vector<IPolicyChildChangeListener>();
        registry.load(this.loadListeners, this.policyMap, this.enumList, this.enumItemList);
        for (String localPolicyId : localIds) {
            ServicePolicyImpl localPolicy = new ServicePolicyImpl(false, localPolicyId, this);
            this.policyMap.put(localPolicyId, localPolicy);
        }
        for (String localPolicyId : localIds) {
            LocalUtils.loadLocalPolicy(localPolicyId, this);
        }
        for (IPolicyPlatformLoadListener loadListener : this.loadListeners) {
            loadListener.load();
        }
        this.commitChanges(false);
    }

    public void addEnabledExpression(Expression expression) {
        if (expression != null) {
            this.enabledList.add(expression);
        }
    }

    public boolean isEnabled(Object object) {
        boolean result = false;
        EvaluationContext context = new EvaluationContext(null, object);
        context.addVariable("selection", object);
        context.setAllowPluginActivation(true);
        for (Expression enabledItem : this.enabledList) {
            try {
                EvaluationResult expResult = enabledItem.evaluate((IEvaluationContext)context);
                if (expResult == EvaluationResult.FALSE) continue;
                result = true;
                break;
            }
            catch (CoreException exc) {
                ServicePolicyActivator.logError("Error evaluating enablement expression.", exc);
            }
        }
        return result;
    }

    public void commitChanges(boolean saveLocals) {
        Vector<String> localIds = new Vector<String>();
        if (saveLocals) {
            LocalUtils.removeAllLocalPolicies();
        }
        for (ServicePolicyImpl policy : this.policyMap.values()) {
            policy.commitChanges();
            if (!saveLocals || policy.isPredefined()) continue;
            LocalUtils.saveLocalPolicy(policy);
            localIds.add(policy.getId());
        }
        if (saveLocals) {
            LocalUtils.saveLocalIds(localIds);
        }
        this.committedPolicyMap = new HashMap<String, ServicePolicyImpl>();
        this.committedPolicyMap.putAll(this.policyMap);
        ServicePolicyActivator.getDefault().savePluginPreferences();
    }

    public void removePolicy(IServicePolicy policy) {
        this.policyMap.remove(policy.getId());
        this.fireChildChangeEvent(policy, false);
    }

    public void removePlatformPolicy(IServicePolicy policy) {
        if (policy.isPredefined()) {
            return;
        }
        IServicePolicy parent = policy.getParentPolicy();
        if (parent == null) {
            Vector<IServicePolicy> children = new Vector<IServicePolicy>(policy.getChildren());
            for (IServicePolicy child : children) {
                policy.removeChild(child);
            }
            this.removePolicy((ServicePolicyImpl)policy);
        } else {
            parent.removeChild(policy);
        }
    }

    public void addChildChangeListener(IPolicyChildChangeListener listener) {
        this.childChangeListeners.add(listener);
    }

    public void removeChildChangeListener(IPolicyChildChangeListener listener) {
        this.childChangeListeners.remove(listener);
    }

    public void queueChildChangeListeners(boolean queue) {
        if (queue && this.queuedChildChangeAdded == null) {
            this.queuedChildChangeAdded = new Vector<Boolean>();
            this.queuedChildChangePolicy = new Vector<IServicePolicy>();
        } else if (!queue && this.queuedChildChangeAdded != null) {
            for (IPolicyChildChangeListener listener : this.childChangeListeners) {
                listener.childChange(this.queuedChildChangePolicy, this.queuedChildChangeAdded);
            }
            this.queuedChildChangeAdded = null;
            this.queuedChildChangePolicy = null;
        }
    }

    public void fireChildChangeEvent(IServicePolicy policy, boolean isAdd) {
        if (this.queuedChildChangeAdded == null) {
            Vector<IServicePolicy> policyList = new Vector<IServicePolicy>(1);
            Vector<Boolean> addedList = new Vector<Boolean>(1);
            policyList.add(policy);
            addedList.add(isAdd);
            for (IPolicyChildChangeListener listener : this.childChangeListeners) {
                listener.childChange(policyList, addedList);
            }
        } else {
            this.queuedChildChangeAdded.add(isAdd);
            this.queuedChildChangePolicy.add(policy);
        }
    }

    public void commitChanges(IProject project) {
        for (ServicePolicyImpl policy : this.policyMap.values()) {
            ((PolicyStateImpl)policy.getPolicyState(project)).commitChanges();
        }
        ProjectEntry entry = this.getProjectEntry(project);
        entry.isEnabledCommitted = entry.isEnabled;
        this.setProjectEnabled(project, entry.isEnabledCommitted);
        try {
            IEclipsePreferences projectPrefs = new ProjectScope(project).getNode("org.eclipse.wst.ws.service.policy");
            projectPrefs.flush();
        }
        catch (BackingStoreException exc) {
            ServicePolicyActivator.logError("Error while committing project preferences.", exc);
        }
    }

    public void discardChanges() {
        this.policyMap = new HashMap<String, ServicePolicyImpl>();
        this.policyMap.putAll(this.committedPolicyMap);
        for (ServicePolicyImpl policy : this.committedPolicyMap.values()) {
            policy.discardChanges();
        }
    }

    public void discardChanges(IProject project) {
        for (ServicePolicyImpl policy : this.policyMap.values()) {
            ((PolicyStateImpl)policy.getPolicyState(project)).discardChanges();
        }
        ProjectEntry entry = this.getProjectEntry(project);
        entry.isEnabled = entry.isEnabledCommitted;
    }

    public void restoreDefaults() {
        for (ServicePolicyImpl policy : this.policyMap.values()) {
            policy.restoreDefaults();
        }
    }

    public void restoreDefaults(IProject project) {
        for (ServicePolicyImpl policy : this.policyMap.values()) {
            policy.restoreDefaults(project);
        }
    }

    public Set<String> getAllPolicyIds() {
        return this.policyMap.keySet();
    }

    public List<IServicePolicy> getRootServicePolicies(IFilter filter) {
        Vector<IServicePolicy> rootPolicies = new Vector<IServicePolicy>();
        for (String policyId : this.policyMap.keySet()) {
            ServicePolicyImpl policy = this.policyMap.get(policyId);
            if (policy.getParentPolicy() != null || filter != null && (filter == null || !filter.accept(policy))) continue;
            rootPolicies.add(policy);
        }
        return rootPolicies;
    }

    public ServicePolicyImpl createServicePolicy(IServicePolicy parent, String id, String enumListId, String defaultEnumId) {
        if (id == null) {
            id = "org.eclipse.wst.ws.service.policy.id";
        }
        String uniqueId = this.makeUniqueId(id);
        ServicePolicyImpl policy = new ServicePolicyImpl(false, uniqueId, this);
        policy.setParent((ServicePolicyImpl)parent);
        policy.setEnumListId(enumListId);
        policy.setDefaultEnumId(defaultEnumId);
        this.policyMap.put(uniqueId, policy);
        this.fireChildChangeEvent(policy, true);
        return policy;
    }

    public ServicePolicyImpl getServicePolicy(String id) {
        return id == null ? null : this.policyMap.get(id);
    }

    public List<IStateEnumerationItem> getStateEnumeration(String enumId) {
        return this.enumList.get(enumId);
    }

    public IStateEnumerationItem getStateItemEnumeration(String stateItemId) {
        return this.enumItemList.get(stateItemId);
    }

    public boolean isProjectPreferencesEnabled(IProject project) {
        ProjectEntry entry = this.getProjectEntry(project);
        return entry.isEnabled;
    }

    private boolean getProjectPreferenceEnabled(IProject project) {
        String pluginId = "org.eclipse.wst.ws.service.policy";
        IEclipsePreferences projectPreference = new ProjectScope(project).getNode(pluginId);
        String key = String.valueOf(pluginId) + ".projectEnabled";
        return projectPreference.getBoolean(key, false);
    }

    public void setProjectPreferencesEnabled(IProject project, boolean value) {
        ProjectEntry entry = this.getProjectEntry(project);
        entry.isEnabled = value;
    }

    private void setProjectEnabled(IProject project, boolean value) {
        String pluginId = "org.eclipse.wst.ws.service.policy";
        IEclipsePreferences projectPreference = new ProjectScope(project).getNode(pluginId);
        String key = String.valueOf(pluginId) + ".projectEnabled";
        projectPreference.putBoolean(key, value);
    }

    private ProjectEntry getProjectEntry(IProject project) {
        ProjectEntry entry = this.enabledProjectMap.get(project);
        if (entry == null) {
            entry = new ProjectEntry();
            this.enabledProjectMap.put(project, entry);
            entry.isEnabled = entry.isEnabledCommitted = this.getProjectPreferenceEnabled(project);
        }
        return entry;
    }

    private String makeUniqueId(String id) {
        String result = id;
        int idCount = 1;
        Pattern pattern = Pattern.compile("\\d*$");
        while (this.policyMap.containsKey(result)) {
            Matcher matcher = pattern.matcher(result);
            result = String.valueOf(matcher.replaceFirst("")) + idCount;
            ++idCount;
        }
        return result;
    }

    private class ProjectEntry {
        boolean isEnabledCommitted;
        boolean isEnabled;

        private ProjectEntry() {
        }
    }
}

