/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.CatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.catalog.EditCatalogEntryDialog;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogTreeViewer;

public class XMLCatalogEntriesView
extends Composite {
    protected Button newButton;
    protected Button editButton;
    protected Button deleteButton;
    protected XMLCatalogTreeViewer tableViewer;
    protected ICatalog workingUserCatalog;
    protected ICatalog systemCatalog;

    public XMLCatalogEntriesView(Composite parent, ICatalog workingUserCatalog, ICatalog systemCatalog) {
        super(parent, 0);
        this.workingUserCatalog = workingUserCatalog;
        this.systemCatalog = systemCatalog;
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.tableViewer = this.createTableViewer(this);
        this.tableViewer.setInput("dummy");
        Point initialSize = this.tableViewer.getTree().computeSize(-1, -1);
        GridData gridData = new GridData(1808);
        gridData.widthHint = initialSize.x;
        gridData.heightHint = initialSize.y;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.tableViewer.expandToLevel(2);
        this.tableViewer.reveal(XMLCatalogTreeViewer.USER_SPECIFIED_ENTRIES_OBJECT);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XMLCatalogEntriesView.this.updateWidgetEnabledState();
            }
        };
        this.tableViewer.addSelectionChangedListener(listener);
        this.createButtons(this);
    }

    public static String removeLeadingSlash(String uri) {
        if (uri != null) {
            while (uri.startsWith("/") || uri.startsWith("\\")) {
                uri = uri.substring(1);
            }
        }
        return uri;
    }

    protected XMLCatalogTreeViewer createTableViewer(Composite parent) {
        String[] headings = new String[]{XMLCatalogMessages.UI_LABEL_KEY, XMLCatalogMessages.UI_LABEL_URI};
        XMLCatalogTreeViewer theTableViewer = new XMLCatalogTreeViewer(parent, this.workingUserCatalog, this.systemCatalog);
        return theTableViewer;
    }

    protected void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 4;
        Button hiddenButton = new Button(composite, 0);
        hiddenButton.setLayoutData((Object)gd);
        hiddenButton.setVisible(false);
        hiddenButton.setEnabled(false);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == XMLCatalogEntriesView.this.newButton) {
                    XMLCatalogEntriesView.this.performNew();
                } else if (e.widget == XMLCatalogEntriesView.this.editButton) {
                    XMLCatalogEntriesView.this.performEdit();
                } else if (e.widget == XMLCatalogEntriesView.this.deleteButton) {
                    XMLCatalogEntriesView.this.performDelete();
                }
            }
        };
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.newButton = new Button(composite, 0);
        this.newButton.setText(XMLCatalogMessages.UI_BUTTON_NEW);
        this.newButton.setLayoutData((Object)gd);
        this.newButton.addSelectionListener((SelectionListener)selectionListener);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.editButton = new Button(composite, 0);
        this.editButton.setText(XMLCatalogMessages.UI_BUTTON_EDIT);
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)selectionListener);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.deleteButton = new Button(composite, 0);
        this.deleteButton.setText(XMLCatalogMessages.UI_BUTTON_DELETE);
        this.deleteButton.setLayoutData((Object)gd);
        this.deleteButton.addSelectionListener((SelectionListener)selectionListener);
        this.getShell().setDefaultButton(hiddenButton);
        this.updateWidgetEnabledState();
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    protected EditCatalogEntryDialog invokeDialog(String title, ICatalogElement entry) {
        Shell shell = XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        EditCatalogEntryDialog dialog = new EditCatalogEntryDialog(shell, entry);
        dialog.create();
        dialog.getShell().setText(title);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog;
    }

    protected EditCatalogEntryDialog invokeDialog(String title, ICatalog catalog) {
        Shell shell = XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        EditCatalogEntryDialog dialog = new EditCatalogEntryDialog(shell, catalog);
        dialog.create();
        dialog.getShell().setText(title);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog;
    }

    protected void performNew() {
        EditCatalogEntryDialog dialog = this.invokeDialog(XMLCatalogMessages.UI_LABEL_NEW_DIALOG_TITLE, this.workingUserCatalog);
        ICatalogElement element = dialog.getCatalogElement();
        if (dialog.getReturnCode() == 0) {
            this.workingUserCatalog.addCatalogElement(element);
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
            this.tableViewer.refresh();
        }
    }

    protected void performEdit() {
        ICatalogElement oldEntry;
        ICatalogElement newEntry;
        EditCatalogEntryDialog dialog;
        Object selectedObject;
        ISelection selection = this.tableViewer.getSelection();
        Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
        if (selectedObject instanceof ICatalogElement && (dialog = this.invokeDialog(XMLCatalogMessages.UI_LABEL_EDIT_DIALOG_TITLE, newEntry = (ICatalogElement)((CatalogElement)(oldEntry = (ICatalogElement)selectedObject)).clone())).getReturnCode() == 0) {
            this.workingUserCatalog.removeCatalogElement(oldEntry);
            this.workingUserCatalog.addCatalogElement(newEntry);
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newEntry));
        }
    }

    protected void performDelete() {
        Object selectedObject;
        ISelection selection = this.tableViewer.getSelection();
        Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
        if (selectedObject instanceof ICatalogElement) {
            ICatalogElement catalogElement = (ICatalogElement)selectedObject;
            this.workingUserCatalog.removeCatalogElement(catalogElement);
        }
    }

    protected void updateWidgetEnabledState() {
        Object selectedObject;
        boolean isEditable = false;
        ISelection selection = this.tableViewer.getSelection();
        Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
        if (selectedObject instanceof ICatalogElement) {
            ICatalogElement[] elements = ((Catalog)this.workingUserCatalog).getCatalogElements();
            int i = 0;
            while (i < elements.length) {
                ICatalogElement element = elements[i];
                isEditable = selectedObject.equals(element);
                if (isEditable) break;
                ++i;
            }
        }
        this.editButton.setEnabled(isEditable);
        this.deleteButton.setEnabled(isEditable);
    }

    public void updatePage() {
        this.refresh();
        this.updateWidgetEnabledState();
    }

    public Viewer getViewer() {
        return this.tableViewer;
    }
}

