/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.validation.internal.ui.ResourceHandler;

public class ProgressAndTextDialog
extends ProgressMonitorDialog {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected Text text = null;
    protected boolean cancelPressed = false;
    protected boolean closePressed = false;
    protected boolean operationDone = false;
    protected Cursor arrowCursor;

    public ProgressAndTextDialog(Shell parent) {
        super(parent);
        this.setShellStyle(2096);
        this.setBlockOnOpen(false);
    }

    public Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        Composite composite = new Composite(parent, 0);
        Label textLabel = new Label(composite, 16448);
        textLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_STATUS"));
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        textLabel.setLayoutData((Object)labelData);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 250;
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        this.text = new Text(composite, 2826);
        GridData d = new GridData(1808);
        this.text.setLayoutData((Object)d);
        return composite;
    }

    public void addText(final String messageString) {
        if (this.getShell() != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProgressAndTextDialog.this.text.append(messageString);
                    ProgressAndTextDialog.this.text.append(NEWLINE);
                }
            });
        }
    }

    public boolean close() {
        if (this.closePressed) {
            return super.close();
        }
        this.progressIndicator.setVisible(false);
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
        }
        this.getShell().setCursor(this.arrowCursor);
        if (this.cancelPressed) {
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_CANCELLED"));
        } else {
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_COMPLETE"));
        }
        this.cancel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_CLOSE"));
        this.cancel.setEnabled(true);
        return false;
    }

    protected void internalCancelPressed() {
        if (this.operationDone) {
            this.closePressed = true;
            this.close();
        } else {
            this.cancelPressed = true;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ProgressAndTextDialog.this.internalCancelPressed();
            }
        });
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        try {
            super.run(fork, cancelable, runnable);
        }
        finally {
            this.operationDone = true;
        }
    }
}

