/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidationSelectionHandlerRegistryReader;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.ui.SaveFilesDialog;
import org.eclipse.wst.validation.internal.ui.SaveFilesHelper;
import org.eclipse.wst.validation.internal.ui.ValidateAction;
import org.eclipse.wst.validation.internal.ui.ValidationUIMessages;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;
import org.eclipse.wst.validation.ui.internal.ManualValidationRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationMenuAction
implements IViewActionDelegate {
    private ISelection _currentSelection;
    protected static final String SEP = "/";
    private Display _currentDisplay = Display.getCurrent();
    private IResourceVisitor _folderVisitor;
    private IResourceVisitor _projectVisitor;
    private Map<IProject, Set<IResource>> _selectedResources = new HashMap<IProject, Set<IResource>>();

    private Display getDisplay() {
        return this._currentDisplay == null ? Display.getCurrent() : this._currentDisplay;
    }

    Shell getShell() {
        Shell[] shells;
        Shell shell;
        Display display = this.getDisplay();
        Shell shell2 = shell = display == null ? null : display.getActiveShell();
        if (shell == null && display != null && (shells = display.getShells()).length > 0) {
            shell = shells[0];
        }
        return shell;
    }

    private Map<IProject, Set<IResource>> loadSelected(ValidateAction action) {
        Object[] elements;
        this._selectedResources.clear();
        if (this._currentSelection == null || this._currentSelection.isEmpty() || !(this._currentSelection instanceof IStructuredSelection)) {
            return null;
        }
        Object[] objectArray = elements = ((IStructuredSelection)this._currentSelection).toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element != null) {
                this.addSelected(action, element);
            }
            ++n2;
        }
        return this._selectedResources;
    }

    private void addSelected(ValidateAction action, Object selected) {
        if (selected instanceof IProject) {
            this.addVisitor((IProject)selected);
        } else if (selected instanceof IFile) {
            this.addSelected((IResource)((IFile)selected));
        } else if (selected instanceof IFolder) {
            this.addVisitor((IFolder)selected);
        } else if (this.isValidType(this.getExtendedType(selected))) {
            this.addSelected(action, this.getExtendedType(selected));
        } else {
            IResource[] resources;
            boolean valid = false;
            if (action != null && (resources = action.getResource(selected)) != null) {
                valid = true;
                int i = 0;
                while (i < resources.length) {
                    this.addSelected(action, resources[i]);
                    ++i;
                }
            }
            if (!valid) {
                this._selectedResources.clear();
            }
        }
    }

    private Object getExtendedType(Object selected) {
        Object result = ValidationSelectionHandlerRegistryReader.getInstance().getExtendedType(selected);
        return result == null ? selected : result;
    }

    private boolean isValidType(Object object) {
        return object instanceof IProject || object instanceof IFile || object instanceof IFolder;
    }

    void addSelected(IResource selected) {
        IProject project = selected.getProject();
        boolean added = this._selectedResources.containsKey(project);
        Set<IResource> changedRes = null;
        if (added) {
            changedRes = this._selectedResources.get(project);
            if (changedRes == null) {
                return;
            }
        } else {
            changedRes = new HashSet<IResource>();
        }
        if (changedRes.add(selected)) {
            this._selectedResources.put(project, changedRes);
        }
    }

    private void addVisitor(IFolder selected) {
        try {
            selected.accept(this.getFolderVisitor());
        }
        catch (CoreException exc) {
            Logger logger = WTPUIPlugin.getLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationUIPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidationMenuAction.addSelected(IFolder)");
                entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return;
        }
    }

    private IResourceVisitor getFolderVisitor() {
        if (this._folderVisitor == null) {
            this._folderVisitor = new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res instanceof IFile) {
                        ValidationMenuAction.this.addSelected(res);
                    } else if (res instanceof IFolder) {
                        ValidationMenuAction.this.addSelected(res);
                    }
                    return true;
                }
            };
        }
        return this._folderVisitor;
    }

    private void addVisitor(IProject selected) {
        if (!selected.isAccessible()) {
            return;
        }
        try {
            selected.accept(this.getProjectVisitor());
        }
        catch (CoreException exc) {
            Logger logger = WTPUIPlugin.getLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationUIPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidationMenuAction.addSelected(IFolder)");
                entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return;
        }
    }

    private IResourceVisitor getProjectVisitor() {
        if (this._projectVisitor == null) {
            this._projectVisitor = new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res instanceof IFile) {
                        ValidationMenuAction.this.addSelected(res);
                    } else if (res instanceof IFolder) {
                        ValidationMenuAction.this.addSelected(res);
                    }
                    return true;
                }
            };
        }
        return this._projectVisitor;
    }

    public void run(IAction action) {
        Map<IProject, Set<IResource>> projects;
        ValidateAction vaction = null;
        if (action instanceof ValidateAction) {
            vaction = (ValidateAction)action;
        }
        if ((projects = this.loadSelected(vaction)) == null || projects.size() == 0) {
            return;
        }
        if (!this.handleFilesToSave(projects)) {
            return;
        }
        boolean confirm = ValManager.getDefault().getGlobalPreferences().getConfirmDialog();
        ManualValidationRunner.validate(projects, true, false, confirm);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this._currentSelection = selection;
        boolean enabled = true;
        if (ValidationPlugin.isActivated() && ValidationRegistryReader.isActivated()) {
            enabled = this.hasManualValidators(selection);
        }
        action.setEnabled(enabled);
    }

    private boolean hasManualValidators(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object sel : ss) {
                if (!(sel instanceof IResource)) continue;
                IResource resource = (IResource)sel;
                return ValidationFramework.getDefault().hasValidators(resource, true, false);
            }
        }
        return false;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }

    protected boolean handleFilesToSave(Map<IProject, Set<IResource>> projects) {
        List<IFile> fileList = this.getIFiles(projects);
        final IEditorPart[] dirtyEditors = SaveFilesHelper.getDirtyEditors(fileList);
        if (dirtyEditors == null || dirtyEditors.length == 0) {
            return true;
        }
        boolean saveAutomatically = false;
        try {
            saveAutomatically = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration()).getSaveAutomatically();
        }
        catch (InvocationTargetException invocationTargetException) {}
        SaveFilesDialog sfDialog = null;
        if (!saveAutomatically) {
            sfDialog = new SaveFilesDialog(ValidationUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell());
            sfDialog.setInput(Arrays.asList(dirtyEditors));
        }
        if (saveAutomatically || sfDialog.open() == 0) {
            ProgressMonitorDialog ctx = new ProgressMonitorDialog(this.getShell());
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(ValidationUIMessages.SaveFilesDialog_saving, dirtyEditors.length);
                        int numDirtyEditors = dirtyEditors.length;
                        int i = 0;
                        while (i < numDirtyEditors) {
                            dirtyEditors[i].doSave((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            ++i;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                ctx.run(false, true, runnable);
                return true;
            }
            catch (InvocationTargetException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    protected List<IFile> getIFiles(Map<IProject, Set<IResource>> projects) {
        LinkedList<IFile> fileList = new LinkedList<IFile>();
        for (IProject project : projects.keySet()) {
            for (IResource resource : projects.get(project)) {
                if (!(resource instanceof IFile)) continue;
                fileList.add((IFile)resource);
            }
        }
        return fileList;
    }
}

