/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.ui.internal;

import java.text.NumberFormat;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValidationRunner;
import org.eclipse.wst.validation.ui.internal.ValUIMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualValidationRunner
extends WorkspaceJob {
    private Map<IProject, Set<IResource>> _projects;
    private boolean _isManual;
    private boolean _isBuild;
    private boolean _showResults;
    private static NumberFormat _nf = NumberFormat.getIntegerInstance();

    public static void validate(Map<IProject, Set<IResource>> projects, boolean isManual, boolean isBuild, boolean showResults) {
        ManualValidationRunner me = new ManualValidationRunner(projects, isManual, isBuild, showResults);
        me.schedule();
    }

    private ManualValidationRunner(Map<IProject, Set<IResource>> projects, boolean isManual, boolean isBuild, boolean showResults) {
        super(ValUIMessages.Validation);
        this._projects = projects;
        this._isManual = isManual;
        this._isBuild = isBuild;
        this._showResults = showResults;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        final ValOperation vo = ValidationRunner.validate(this._projects, (boolean)this._isManual, (boolean)this._isBuild, (IProgressMonitor)monitor);
        if (vo.getResult().isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this._showResults) {
            Display display = Display.getDefault();
            Runnable run = new Runnable(){

                public void run() {
                    String message = null;
                    ValidationResult vr = vo.getResult();
                    if (vr.getSeverityError() + vr.getSeverityWarning() + vr.getSeverityInfo() == 0) {
                        message = ValUIMessages.ValidationSuccessful;
                    } else {
                        Object[] parms = new String[]{_nf.format(vr.getSeverityError()), _nf.format(vr.getSeverityWarning()), _nf.format(vr.getSeverityInfo())};
                        message = NLS.bind((String)ValUIMessages.ErrSummary, (Object[])parms);
                    }
                    MessageDialog.openInformation(null, (String)ValUIMessages.ValidationStatus, (String)message);
                }
            };
            display.syncExec(run);
        }
        return Status.OK_STATUS;
    }
}

