/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.ui.internal.dialog;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.model.ValidatorHelper;
import org.eclipse.wst.validation.internal.ui.ResourceHandler;
import org.eclipse.wst.validation.ui.internal.AdapterFactory;
import org.eclipse.wst.validation.ui.internal.ValUIMessages;
import org.eclipse.wst.validation.ui.internal.dialog.NewFilterRule;

public class FilterDialog
extends Dialog {
    private Validator _origValidator;
    private IProject _project;
    private Validator _validator;
    private Validator.V2 _v2;
    private TreeViewer _tree;
    private Combo _delegating;
    private IAdapterFactory _adaptorFactory = new AdapterFactory();
    private Button _addGroupInclude;
    private Button _addGroupExclude;
    private Button _addRule;
    private Button _remove;
    private ISelectionChangedListener _nodeChangedListener;
    private FilterGroup _selectedGroup;
    private FilterRule _selectedRule;
    private Shell _shell;

    public FilterDialog(Shell shell, Validator validator, IProject project) {
        super(shell);
        this._shell = shell;
        this.setShellStyle(1232);
        this._origValidator = validator;
        this._validator = validator.copy();
        this._v2 = this._validator.asV2Validator();
        this._project = project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)ValUIMessages.fdTitle, (Object)this._validator.getName()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        c.setLayout((Layout)new GridLayout(2, false));
        if (this._v2 == null) {
            new Label(c, 0).setText(ValUIMessages.fdNoFilters);
        } else {
            Label blurb = new Label(c, 16448);
            blurb.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            blurb.setText(ValUIMessages.FilterHelp);
            this._tree = new TreeViewer(c, 772);
            this._tree.getControl().setLayoutData((Object)new GridData(375, 300));
            Platform.getAdapterManager().registerAdapters(this._adaptorFactory, Validator.V2.class);
            Platform.getAdapterManager().registerAdapters(this._adaptorFactory, FilterGroup.class);
            Platform.getAdapterManager().registerAdapters(this._adaptorFactory, FilterRule.class);
            this._tree.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
            this._tree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this._tree.setInput((Object)this._v2);
            this._tree.expandAll();
            Composite buttons = new Composite(c, 128);
            GridData gd = new GridData(16384, 128, false, false, 1, 1);
            buttons.setLayoutData((Object)gd);
            buttons.setLayout((Layout)new GridLayout(1, true));
            this._addGroupInclude = new Button(buttons, 0x100000C);
            this._addGroupInclude.setText(ValUIMessages.ButtonAddGroupInclude);
            this._addGroupInclude.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this._addGroupInclude.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    FilterDialog.this.addGroup(false);
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterDialog.this.addGroup(false);
                }
            });
            this._addGroupExclude = new Button(buttons, 0x100000C);
            this._addGroupExclude.setText(ValUIMessages.ButtonAddGroupExclude);
            this._addGroupExclude.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this._addGroupExclude.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    FilterDialog.this.addGroup(true);
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterDialog.this.addGroup(true);
                }
            });
            this._addRule = new Button(buttons, 0x100000C);
            this._addRule.setText(ValUIMessages.ButtonAddRule);
            this._addRule.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this._addRule.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.doIt();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.doIt();
                }

                private void doIt() {
                    NewFilterRule nfr = new NewFilterRule(FilterDialog.this._project);
                    WizardDialog wd = new WizardDialog(FilterDialog.this._shell, (IWizard)nfr);
                    wd.setBlockOnOpen(true);
                    int rc = wd.open();
                    if (rc == 1) {
                        return;
                    }
                    FilterRule rule = nfr.getRule();
                    if (rule != null) {
                        FilterDialog.this._selectedGroup.add(rule);
                        FilterDialog.this.refresh();
                    }
                }
            });
            this._remove = new Button(buttons, 0x100000C);
            this._remove.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this._remove.setText(ValUIMessages.ButtonRemove);
            this._remove.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    FilterDialog.this.remove();
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterDialog.this.remove();
                }
            });
            String delegatingId = this._v2.getDelegatingId();
            if (delegatingId != null) {
                this.addDelegatorSelection(c);
            }
            this._nodeChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    FilterDialog.this._selectedGroup = null;
                    FilterDialog.this._selectedRule = null;
                    if (event.getSelection() instanceof IStructuredSelection) {
                        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                        if (sel.getFirstElement() instanceof FilterGroup) {
                            FilterDialog.this._selectedGroup = (FilterGroup)sel.getFirstElement();
                        } else if (sel.getFirstElement() instanceof FilterRule) {
                            FilterDialog.this._selectedRule = (FilterRule)sel.getFirstElement();
                        }
                    }
                    FilterDialog.this.updateButtons();
                }
            };
            this._tree.addSelectionChangedListener(this._nodeChangedListener);
        }
        return c;
    }

    private void addDelegatorSelection(Composite c) {
        Map map = ValidatorDelegatesRegistry.getInstance().getDelegateDescriptors(this._v2.getValidatorClassname());
        if (map == null) {
            return;
        }
        Composite line = new Composite(c, 0);
        line.setLayout((Layout)new RowLayout(256));
        Label label = new Label(line, 0x1000000);
        label.setText(ResourceHandler.getExternalizedMessage("DELEGATES_COMBO_LABEL"));
        this._delegating = new Combo(line, 8);
        String[] items = new String[map.size()];
        final String[] ids = new String[map.size()];
        String selected = null;
        Iterator it = map.values().iterator();
        int i = 0;
        while (i < items.length) {
            ValidatorDelegateDescriptor vd = (ValidatorDelegateDescriptor)it.next();
            items[i] = vd.getName();
            ids[i] = vd.getId();
            if (vd.getId().equals(this._v2.getDelegatingId())) {
                selected = vd.getName();
            }
            ++i;
        }
        this._delegating.setItems(items);
        this._delegating.setText(selected);
        this._delegating.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int sel = FilterDialog.this._delegating.getSelectionIndex();
                FilterDialog.this._v2.setDelegatingId(ids[sel]);
            }
        });
    }

    private void addGroup(boolean exclude) {
        if (this._v2 == null) {
            return;
        }
        this._v2.add(FilterGroup.create((boolean)exclude));
        this.refresh();
    }

    private void refresh() {
        this._tree.refresh();
        this.updateButtons();
    }

    private void remove() {
        if (this._selectedRule != null) {
            FilterGroup[] groups = this._v2.getGroups();
            int i = 0;
            while (i < groups.length) {
                if (groups[i].remove(this._selectedRule)) {
                    this.refresh();
                    return;
                }
                ++i;
            }
        }
        if (this._selectedGroup != null) {
            this._v2.remove(this._selectedGroup);
            this.refresh();
            return;
        }
    }

    protected void okPressed() {
        super.okPressed();
        Validator.V2 v = this._origValidator.asV2Validator();
        if (v != null) {
            v.setGroups(this._v2.getGroups());
            v.setDelegatingId(this._v2.getDelegatingId());
            ValPrefManagerGlobal vpm = new ValPrefManagerGlobal();
            vpm.save((Validator)v);
        }
    }

    private void updateButtons() {
        if (this._v2 != null) {
            this._addGroupExclude.setEnabled(!ValidatorHelper.hasExcludeGroup((Validator.V2)this._v2));
        }
        this._addRule.setEnabled(this._selectedGroup != null);
        this._remove.setEnabled(this._selectedGroup != null || this._selectedRule != null);
    }

    public boolean close() {
        Platform.getAdapterManager().unregisterAdapters(this._adaptorFactory);
        if (this._tree != null) {
            this._tree.removeSelectionChangedListener(this._nodeChangedListener);
        }
        return super.close();
    }

    protected Point getInitialSize() {
        return new Point(550, 475);
    }
}

