/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.ui.internal.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.ui.internal.ValUIMessages;

public class NewFilterRule
extends Wizard {
    private Page1 _page1;
    private IWizardPage _page2;
    private IProject _project;
    private FilterRule _rule;

    public NewFilterRule(IProject project) {
        this._project = project;
        this.setWindowTitle(ValUIMessages.FrWizard);
        this._page1 = new Page1(project);
        this.addPage((IWizardPage)this._page1);
        this.setForcePreviousAndNextButtons(true);
    }

    public boolean canFinish() {
        if (this._page2 != null) {
            return this._page2.isPageComplete();
        }
        return false;
    }

    public FilterRule getRule() {
        return this._rule;
    }

    public boolean performFinish() {
        if (this._page2 == null) {
            return false;
        }
        FilterWizardPage page = (FilterWizardPage)this._page2;
        this._rule = page.getFilterRule();
        return this._rule != null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this._page1) {
            this.setForcePreviousAndNextButtons(false);
            this._page2 = this.returnOrBuildPage(this._page1.getSelectedFilter());
            return this._page2;
        }
        return null;
    }

    private IWizardPage returnOrBuildPage(int selectedFilter) {
        WizardPage page = null;
        switch (selectedFilter) {
            case 0: {
                page = new FileExtPage();
                break;
            }
            case 1: {
                page = new FilePage(this._project);
                break;
            }
            case 2: {
                page = new ProjectPage();
                break;
            }
            case 3: {
                page = new FacetPage();
                break;
            }
            case 4: {
                page = new ContentTypePage();
            }
        }
        this.addPage((IWizardPage)page);
        return page;
    }

    public static class ContentTypePage
    extends WizardPage
    implements FilterWizardPage {
        private Text _pattern;

        public ContentTypePage() {
            super("contentType", ValUIMessages.FrContentType, null);
        }

        public void createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(2, false));
            new Label(control, 0).setText(ValUIMessages.FrContentTypeLabel);
            this._pattern = new Text(control, 0);
            this._pattern.setFocus();
            this._pattern.setLayoutData((Object)new GridData(300, 14));
            this._pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ContentTypePage.this.getContainer().updateButtons();
                }
            });
        }

        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            FilterRule rule = FilterRule.createContentType((String)this._pattern.getText());
            return rule;
        }

        public boolean isPageComplete() {
            return this._pattern.getText().trim().length() > 0;
        }
    }

    public static class FacetPage
    extends WizardPage
    implements FilterWizardPage {
        private Text _pattern;

        public FacetPage() {
            super("facet", ValUIMessages.FrFacit, null);
        }

        public void createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(2, false));
            new Label(control, 0).setText(ValUIMessages.FrFacitLabel);
            this._pattern = new Text(control, 0);
            this._pattern.setFocus();
            this._pattern.setLayoutData((Object)new GridData(300, 14));
            this._pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FacetPage.this.getContainer().updateButtons();
                }
            });
        }

        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            FilterRule rule = FilterRule.createFacet((String)this._pattern.getText());
            return rule;
        }

        public boolean isPageComplete() {
            return this._pattern.getText().trim().length() > 0;
        }
    }

    public static class FileExtPage
    extends WizardPage
    implements FilterWizardPage {
        private Text _pattern;
        private Button _case;

        public FileExtPage() {
            super("fileext", ValUIMessages.FrFileExtension, null);
        }

        public void createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(2, false));
            new Label(control, 0).setText(ValUIMessages.FrFileExtensionLabel);
            this._pattern = new Text(control, 0);
            this._pattern.setFocus();
            this._pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FileExtPage.this.getContainer().updateButtons();
                }
            });
            this._case = new Button(control, 32);
            this._case.setText(ValUIMessages.FrCaseSensitive);
            this._case.setSelection(false);
            this._case.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        }

        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            return FilterRule.FileExt.createFileExt((String)this._pattern.getText(), (boolean)this._case.getSelection());
        }

        public boolean isPageComplete() {
            return this._pattern != null && this._pattern.getText().trim().length() > 0;
        }
    }

    public static class FilePage
    extends WizardPage
    implements FilterWizardPage {
        private Text _pattern;
        private Button _browseFile;
        private Button _browseFolder;
        private Button _case;
        private IProject _project;
        private int _type;

        public FilePage(IProject project) {
            super("file", ValUIMessages.FrFolderOrFile, null);
            this._project = project;
        }

        public void createControl(Composite parent) {
            final Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(4, false));
            new Label(control, 0).setText(ValUIMessages.FrFolderOrFileLabel);
            this._pattern = new Text(control, 0);
            this._pattern.setFocus();
            this._pattern.setLayoutData((Object)new GridData(300, 14));
            this._pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FilePage.this.getContainer().updateButtons();
                }
            });
            this._browseFile = new Button(control, 8);
            this._browseFile.setText(ValUIMessages.FrBrowseFile);
            this._browseFile.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.browse();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.browse();
                }

                private void browse() {
                    String file;
                    FileDialog fd = new FileDialog(control.getShell(), 4096);
                    fd.setText(ValUIMessages.FrFileFilter);
                    IPath base = FilePage.this._project == null ? ResourcesPlugin.getWorkspace().getRoot().getLocation() : FilePage.this._project.getLocation();
                    String root = null;
                    if (base != null) {
                        root = base.toOSString();
                        fd.setFilterPath(root);
                    }
                    if ((file = fd.open()) != null) {
                        if (root != null && file.startsWith(root) && file.length() > root.length()) {
                            file = file.substring(root.length() + 1);
                            FilePage.this._type = 1;
                        } else {
                            FilePage.this._type = 3;
                        }
                        FilePage.this._pattern.setText(file);
                    }
                }
            });
            this._browseFolder = new Button(control, 8);
            this._browseFolder.setText(ValUIMessages.FrBrowseFolder);
            this._browseFolder.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.browse();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.browse();
                }

                private void browse() {
                    String dir;
                    DirectoryDialog fd = new DirectoryDialog(control.getShell());
                    fd.setMessage(ValUIMessages.FrFolderFilter);
                    IPath base = FilePage.this._project == null ? ResourcesPlugin.getWorkspace().getRoot().getLocation() : FilePage.this._project.getLocation();
                    String root = null;
                    if (base != null) {
                        root = base.toOSString();
                        fd.setFilterPath(root);
                    }
                    if ((dir = fd.open()) != null) {
                        if (root != null && dir.startsWith(root) && dir.length() > root.length()) {
                            dir = dir.substring(root.length() + 1);
                            FilePage.this._type = 2;
                        } else {
                            FilePage.this._type = 3;
                        }
                        FilePage.this._pattern.setText(dir);
                    }
                }
            });
            this._case = new Button(control, 32);
            this._case.setText(ValUIMessages.FrCaseSensitive);
            this._case.setSelection(false);
            this._case.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        }

        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            return FilterRule.createFile((String)this._pattern.getText(), (boolean)this._case.getSelection(), (int)this._type);
        }

        public boolean isPageComplete() {
            return this._pattern.getText().trim().length() > 0;
        }
    }

    static interface FilterWizardPage {
        public FilterRule getFilterRule();
    }

    public static class Page1
    extends WizardPage {
        private int _selectedFilter;
        private IProject _project;

        public Page1(IProject project) {
            super("page1", ValUIMessages.FrSelectFilterType, null);
            this.setPageComplete(true);
            this._project = project;
        }

        public void createControl(Composite parent) {
            String[] labels = null;
            String[] desc = null;
            if (this._project != null) {
                labels = new String[]{ValUIMessages.LabelExtension, ValUIMessages.LabelFile, ValUIMessages.LabelContentType};
                desc = new String[]{ValUIMessages.DescExtension, ValUIMessages.DescFile, ValUIMessages.DescContentType};
            } else {
                labels = new String[]{ValUIMessages.LabelExtension, ValUIMessages.LabelFile, ValUIMessages.LabelProjects, ValUIMessages.LabelFacets, ValUIMessages.LabelContentType};
                desc = new String[]{ValUIMessages.DescExtension, ValUIMessages.DescFile, ValUIMessages.DescProjects, ValUIMessages.DescFacets, ValUIMessages.DescContentType};
            }
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)new GridLayout(2, false));
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.doIt(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    this.doIt(e);
                }

                private void doIt(SelectionEvent e) {
                    Button b;
                    if (e.getSource() instanceof Button && (b = (Button)e.getSource()).getData() instanceof Integer) {
                        Integer index = (Integer)b.getData();
                        Page1.this.setSelectedFilter(index);
                    }
                }
            };
            int i = 0;
            while (i < labels.length) {
                Button button = new Button(control, 16);
                button.setText(labels[i]);
                button.setData((Object)new Integer(i));
                button.addSelectionListener(listener);
                new Label(control, 64).setText(desc[i]);
                if (i == 0) {
                    button.setSelection(true);
                }
                ++i;
            }
            this.setControl((Control)control);
        }

        public int getSelectedFilter() {
            return this._selectedFilter;
        }

        public void setSelectedFilter(int selectedFilter) {
            this._selectedFilter = selectedFilter;
            this.getContainer().updateButtons();
        }
    }

    public static class ProjectPage
    extends WizardPage
    implements FilterWizardPage {
        private Combo _natures;
        private String[] _ids;

        public ProjectPage() {
            super("project", ValUIMessages.FrProjectNature, null);
        }

        public void createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            control.setLayout((Layout)new GridLayout(2, false));
            new Label(control, 0).setText(ValUIMessages.FrProjectNatureLabel);
            IProjectNatureDescriptor[] pn = ResourcesPlugin.getWorkspace().getNatureDescriptors();
            String[] items = new String[pn.length];
            this._ids = new String[pn.length];
            int i = 0;
            while (i < pn.length) {
                this._ids[i] = pn[i].getNatureId();
                items[i] = String.valueOf(pn[i].getLabel()) + " - " + this._ids[i];
                ++i;
            }
            this._natures = new Combo(control, 4);
            this._natures.setItems(items);
            this._natures.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectPage.this.getContainer().updateButtons();
                }
            });
        }

        public FilterRule getFilterRule() {
            if (!this.isPageComplete()) {
                return null;
            }
            int i = this._natures.getSelectionIndex();
            if (i == -1) {
                return null;
            }
            return FilterRule.createProject((String)this._ids[i]);
        }

        public boolean isPageComplete() {
            return this._natures.getText().trim().length() > 0;
        }
    }
}

